package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0021;
import cn.ibizlab.core.sample.filter.IBIZSample0021SearchContext;

public interface IBIZSample0021Service extends IService<IBIZSample0021> {

    default IBIZSample0021Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0021 get(IBIZSample0021 et);
    default IBIZSample0021 get(String key) {
        IBIZSample0021 et = new IBIZSample0021();
        et.setIbizSample0021Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0021> getByIds(Collection<String> ids) {
        List<IBIZSample0021> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0021 et = new IBIZSample0021();
            et.setIbizSample0021Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0021> getByEntities(List<IBIZSample0021> entities);

    IBIZSample0021 getDraft(IBIZSample0021 et);

    Integer checkKey(IBIZSample0021 et);

    boolean create(IBIZSample0021 et);
    boolean createBatch(List<IBIZSample0021> list);

    boolean update(IBIZSample0021 et);
    boolean updateBatch(List<IBIZSample0021> list);

    boolean save(IBIZSample0021 et);
    boolean saveBatch(List<IBIZSample0021> list);

    default boolean remove(String key) {
        IBIZSample0021 et = new IBIZSample0021();
        et.setIbizSample0021Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0021 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0021> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0021 et = new IBIZSample0021();
            et.setIbizSample0021Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0021> entities);

    Page<IBIZSample0021> searchDefault(IBIZSample0021SearchContext context);
    List<IBIZSample0021> listDefault(IBIZSample0021SearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}