package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0002;

public interface IBIZSample0001Service extends IService<IBIZSample0001> {

    default IBIZSample0001Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0001 get(IBIZSample0001 et);
    default IBIZSample0001 get(String key) {
        IBIZSample0001 et = new IBIZSample0001();
        et.setIbizSample0001Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0001> getByIds(Collection<String> ids) {
        List<IBIZSample0001> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0001 et = new IBIZSample0001();
            et.setIbizSample0001Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0001> getByEntities(List<IBIZSample0001> entities);

    IBIZSample0001 getDraft(IBIZSample0001 et);

    Integer checkKey(IBIZSample0001 et);

    boolean create(IBIZSample0001 et);
    boolean createBatch(List<IBIZSample0001> list);

    boolean update(IBIZSample0001 et);
    boolean updateBatch(List<IBIZSample0001> list);

    boolean save(IBIZSample0001 et);
    boolean saveBatch(List<IBIZSample0001> list);

    default boolean remove(String key) {
        IBIZSample0001 et = new IBIZSample0001();
        et.setIbizSample0001Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0001 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0001> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0001 et = new IBIZSample0001();
            et.setIbizSample0001Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0001> entities);

    Page<IBIZSample0001> searchDefault(IBIZSample0001SearchContext context);
    List<IBIZSample0001> listDefault(IBIZSample0001SearchContext context);

    List<IBIZSample0001> selectByIbizSample0002Id(String ibizSample0002Id);
    boolean removeByIbizSample0002Id(String ibizSample0002Id);
    boolean resetByIbizSample0002Id(String ibizSample0002Id);
    boolean saveBySample0002Sample00011N(cn.ibizlab.core.sample.domain.IBIZSample0002 ibizSample0002,List<IBIZSample0001> list);
    default boolean saveByIbizSample0002Id(String ibizSample0002Id,List<IBIZSample0001> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0002 et = new cn.ibizlab.core.sample.domain.IBIZSample0002();
        et.setIbizSample0002Id(ibizSample0002Id);
        return getSelf().saveBySample0002Sample00011N(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}