package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
/**
 * 关系型数据实体[IBIZSample0011] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单明细")
public class IBIZSample0011SearchContext extends QueryWrapperContext<IBIZSample0011> {

    @JsonProperty("n_ibizsample0011id_eq")
    @JSONField(name = "n_ibizsample0011id_eq")
    @ApiModelProperty("订单明细标识EQ")
	private String ibizSample0011IdEQ;
	public IBIZSample0011SearchContext setIbizSample0011IdEQ(String ibizSample0011IdEQ) {
        this.ibizSample0011IdEQ = ibizSample0011IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0011IdEQ)){
            this.getSearchCond().eq("ibizsample0011id", ibizSample0011IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0011name_like")
    @JSONField(name = "n_ibizsample0011name_like")
    @ApiModelProperty("订单明细名称LIKE")
	private String ibizSample0011NameLIKE;
	public IBIZSample0011SearchContext setIbizSample0011NameLIKE(String ibizSample0011NameLIKE) {
        this.ibizSample0011NameLIKE = ibizSample0011NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0011NameLIKE)){
            this.getSearchCond().like("ibizsample0011name", ibizSample0011NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0010name_eq")
    @JSONField(name = "n_ibizsample0010name_eq")
    @ApiModelProperty("订单名称EQ")
	private String ibizSample0010NameEQ;
	public IBIZSample0011SearchContext setIbizSample0010NameEQ(String ibizSample0010NameEQ) {
        this.ibizSample0010NameEQ = ibizSample0010NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0010NameEQ)){
            this.getSearchCond().eq("ibizsample0010name", ibizSample0010NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0010name_like")
    @JSONField(name = "n_ibizsample0010name_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizSample0010NameLIKE;
	public IBIZSample0011SearchContext setIbizSample0010NameLIKE(String ibizSample0010NameLIKE) {
        this.ibizSample0010NameLIKE = ibizSample0010NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0010NameLIKE)){
            this.getSearchCond().like("ibizsample0010name", ibizSample0010NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_eq")
    @JSONField(name = "n_ibizuniproductname_eq")
    @ApiModelProperty("统一产品名称EQ")
	private String ibizuniProductNameEQ;
	public IBIZSample0011SearchContext setIbizuniProductNameEQ(String ibizuniProductNameEQ) {
        this.ibizuniProductNameEQ = ibizuniProductNameEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameEQ)){
            this.getSearchCond().eq("ibizuniproductname", ibizuniProductNameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_like")
    @JSONField(name = "n_ibizuniproductname_like")
    @ApiModelProperty("统一产品名称LIKE")
	private String ibizuniProductNameLIKE;
	public IBIZSample0011SearchContext setIbizuniProductNameLIKE(String ibizuniProductNameLIKE) {
        this.ibizuniProductNameLIKE = ibizuniProductNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameLIKE)){
            this.getSearchCond().like("ibizuniproductname", ibizuniProductNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0010id_eq")
    @JSONField(name = "n_ibizsample0010id_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizSample0010IdEQ;
	public IBIZSample0011SearchContext setIbizSample0010IdEQ(String ibizSample0010IdEQ) {
        this.ibizSample0010IdEQ = ibizSample0010IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0010IdEQ)){
            this.getSearchCond().eq("ibizsample0010id", ibizSample0010IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductid_eq")
    @JSONField(name = "n_ibizuniproductid_eq")
    @ApiModelProperty("统一产品标识EQ")
	private String ibizuniProductIdEQ;
	public IBIZSample0011SearchContext setIbizuniProductIdEQ(String ibizuniProductIdEQ) {
        this.ibizuniProductIdEQ = ibizuniProductIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductIdEQ)){
            this.getSearchCond().eq("ibizuniproductid", ibizuniProductIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0011name", query)
            );
		}
	}
}