package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import cn.ibizlab.core.sample.domain.IBIZCustomer;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZACCOUNT", resultMap = "IBIZAccountResultMap")
@ApiModel(value = "IBIZACCOUNT", description = "账户")
public class IBIZAccount extends EntityMP implements Serializable
{

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 开户行
     */
    @TableField(value = "bankname")
    @DEField(name = "bankname")
    @JsonProperty("bankname")
    @JSONField(name = "bankname")
    @ApiModelProperty(value = "bankname", notes = "开户行")
    private String bankName;

    /**
     * 账户名称
     */
    @TableField(value = "ibizaccountname")
    @DEField(name = "ibizaccountname")
    @JsonProperty("ibizaccountname")
    @JSONField(name = "ibizaccountname")
    @ApiModelProperty(value = "ibizaccountname", notes = "账户名称")
    private String ibizAccountName;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 开户银行号
     */
    @TableField(value = "bankaccountnum")
    @DEField(name = "bankaccountnum")
    @JsonProperty("bankaccountnum")
    @JSONField(name = "bankaccountnum")
    @ApiModelProperty(value = "bankaccountnum", notes = "开户银行号")
    private String bankAccountNum;

    /**
     * 账户标识
     */
    @Id
    @TableId(value = "ibizaccountid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizaccountid" , isKeyField = true)
    @JsonProperty("ibizaccountid")
    @JSONField(name = "ibizaccountid")
    @ApiModelProperty(value = "ibizaccountid", notes = "账户标识")
    private String ibizAccountId;


    /**
     * 客户
     */
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    @ApiModelProperty(value = "ibizcustomer", notes = "")
    private IBIZCustomer ibizcustomer;




    /**
     * 设置 [开户行]
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
        this.modify("bankname", bankName);
    }

    /**
     * 设置 [账户名称]
     */
    public void setIbizAccountName(String ibizAccountName) {
        this.ibizAccountName = ibizAccountName;
        this.modify("ibizaccountname", ibizAccountName);
    }



    /**
     * 设置 [开户银行号]
     */
    public void setBankAccountNum(String bankAccountNum) {
        this.bankAccountNum = bankAccountNum;
        this.modify("bankaccountnum", bankAccountNum);
    }




    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizaccountid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}