package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.MicroComponent;
/**
 * 关系型数据实体[MicroComponent] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("微组件")
public class MicroComponentSearchContext extends QueryWrapperContext<MicroComponent> {

    @JsonProperty("n_microcomponentname_like")
    @JSONField(name = "n_microcomponentname_like")
    @ApiModelProperty("微组件名称LIKE")
	private String microComponentNameLIKE;
	public MicroComponentSearchContext setMicroComponentNameLIKE(String microComponentNameLIKE) {
        this.microComponentNameLIKE = microComponentNameLIKE;
        if(!ObjectUtils.isEmpty(this.microComponentNameLIKE)){
            this.getSearchCond().like("microcomponentname", microComponentNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_microcomponentid_eq")
    @JSONField(name = "n_microcomponentid_eq")
    @ApiModelProperty("微组件标识EQ")
	private String microComponentIdEQ;
	public MicroComponentSearchContext setMicroComponentIdEQ(String microComponentIdEQ) {
        this.microComponentIdEQ = microComponentIdEQ;
        if(!ObjectUtils.isEmpty(this.microComponentIdEQ)){
            this.getSearchCond().eq("microcomponentid", microComponentIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("microcomponentname", query)
            );
		}
	}
}