package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
/**
 * 关系型数据实体[IBIZSample0010] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZSample0010SearchContext extends QueryWrapperContext<IBIZSample0010> {

    @JsonProperty("n_ordertype_eq")
    @JSONField(name = "n_ordertype_eq")
    @ApiModelProperty("订单类型EQ")
	private String orderTypeEQ;
	public IBIZSample0010SearchContext setOrderTypeEQ(String orderTypeEQ) {
        this.orderTypeEQ = orderTypeEQ;
        if(!ObjectUtils.isEmpty(this.orderTypeEQ)){
            this.getSearchCond().eq("ordertype", orderTypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0010name_like")
    @JSONField(name = "n_ibizsample0010name_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizSample0010NameLIKE;
	public IBIZSample0010SearchContext setIbizSample0010NameLIKE(String ibizSample0010NameLIKE) {
        this.ibizSample0010NameLIKE = ibizSample0010NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0010NameLIKE)){
            this.getSearchCond().like("ibizsample0010name", ibizSample0010NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_gtandeq")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_gtandeq" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间GTANDEQ")
	private Timestamp orderTimeGTANDEQ;
	public IBIZSample0010SearchContext setOrderTimeGTANDEQ(Timestamp orderTimeGTANDEQ) {
        this.orderTimeGTANDEQ = orderTimeGTANDEQ;
        if(!ObjectUtils.isEmpty(this.orderTimeGTANDEQ)){
            this.getSearchCond().ge("ordertime", orderTimeGTANDEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_ltandeq")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_ltandeq" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间LTANDEQ")
	private Timestamp orderTimeLTANDEQ;
	public IBIZSample0010SearchContext setOrderTimeLTANDEQ(Timestamp orderTimeLTANDEQ) {
        this.orderTimeLTANDEQ = orderTimeLTANDEQ;
        if(!ObjectUtils.isEmpty(this.orderTimeLTANDEQ)){
            this.getSearchCond().le("ordertime", orderTimeLTANDEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0010id_eq")
    @JSONField(name = "n_ibizsample0010id_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizSample0010IdEQ;
	public IBIZSample0010SearchContext setIbizSample0010IdEQ(String ibizSample0010IdEQ) {
        this.ibizSample0010IdEQ = ibizSample0010IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0010IdEQ)){
            this.getSearchCond().eq("ibizsample0010id", ibizSample0010IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0010name", query)
            );
		}
	}
}