package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZBOOK;
/**
 * 关系型数据实体[IBIZBOOK] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("图书")
public class IBIZBOOKSearchContext extends QueryWrapperContext<IBIZBOOK> {

    @JsonProperty("n_ibizbookname_like")
    @JSONField(name = "n_ibizbookname_like")
    @ApiModelProperty("图书名称LIKE")
	private String ibizbookNameLIKE;
	public IBIZBOOKSearchContext setIbizbookNameLIKE(String ibizbookNameLIKE) {
        this.ibizbookNameLIKE = ibizbookNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizbookNameLIKE)){
            this.getSearchCond().like("ibizbookname", ibizbookNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizbookid_eq")
    @JSONField(name = "n_ibizbookid_eq")
    @ApiModelProperty("图书标识EQ")
	private String ibizbookidEQ;
	public IBIZBOOKSearchContext setIbizbookidEQ(String ibizbookidEQ) {
        this.ibizbookidEQ = ibizbookidEQ;
        if(!ObjectUtils.isEmpty(this.ibizbookidEQ)){
            this.getSearchCond().eq("ibizbookid", ibizbookidEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_price_gtandeq")
    @JSONField(name = "n_price_gtandeq")
    @ApiModelProperty("图书价格GTANDEQ")
	private BigDecimal priceGTANDEQ;
	public IBIZBOOKSearchContext setPriceGTANDEQ(BigDecimal priceGTANDEQ) {
        this.priceGTANDEQ = priceGTANDEQ;
        if(!ObjectUtils.isEmpty(this.priceGTANDEQ)){
            this.getSearchCond().ge("price", priceGTANDEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_type_eq")
    @JSONField(name = "n_type_eq")
    @ApiModelProperty("图书类型EQ")
	private String typeEQ;
	public IBIZBOOKSearchContext setTypeEQ(String typeEQ) {
        this.typeEQ = typeEQ;
        if(!ObjectUtils.isEmpty(this.typeEQ)){
            this.getSearchCond().eq("type", typeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_sailstate_eq")
    @JSONField(name = "n_sailstate_eq")
    @ApiModelProperty("图书销售状态EQ")
	private String sailstateEQ;
	public IBIZBOOKSearchContext setSailstateEQ(String sailstateEQ) {
        this.sailstateEQ = sailstateEQ;
        if(!ObjectUtils.isEmpty(this.sailstateEQ)){
            this.getSearchCond().eq("sailstate", sailstateEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_borrowway_eq")
    @JSONField(name = "n_borrowway_eq")
    @ApiModelProperty("借阅方式EQ")
	private String borrowwayEQ;
	public IBIZBOOKSearchContext setBorrowwayEQ(String borrowwayEQ) {
        this.borrowwayEQ = borrowwayEQ;
        if(!ObjectUtils.isEmpty(this.borrowwayEQ)){
            this.getSearchCond().eq("borrowway", borrowwayEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_returnlib_eq")
    @JSONField(name = "n_returnlib_eq")
    @ApiModelProperty("归还图馆EQ")
	private String returnlibEQ;
	public IBIZBOOKSearchContext setReturnlibEQ(String returnlibEQ) {
        this.returnlibEQ = returnlibEQ;
        if(!ObjectUtils.isEmpty(this.returnlibEQ)){
            this.getSearchCond().eq("returnlib", returnlibEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizbookname", query)
            );
		}
	}
}