import { Environment } from '@/environments/environment';
import { UIActionTool, Util } from '@/utils';
import axios from 'axios';
import AppCenterService from "@service/app/app-center-service";
import UIService from '../ui-service';
import { Subject } from 'rxjs';
import IBIZBOOKService from '@/service/ibizbook/ibizbook-service';
import IBIZBOOKAuthService from '@/authservice/ibizbook/ibizbook-auth-service';
import CustomEditUILogic from './custom-edit-ui-logic';
import CustomViewFormLoadUILogic from './custom-view-form-load-ui-logic';
import CustomViewGridLoadUILogic from './custom-view-grid-load-ui-logic';
import FormLoadUILogic from './form-load-ui-logic';
import GridLoadUILogic from './grid-load-ui-logic';
import PrintParamsUILogic from './print-params-ui-logic';
import ActiontestUILogic from './actiontest-ui-logic';
import CancelSelectUILogic from './cancel-select-ui-logic';
import CustomViewDestroyUILogic from './custom-view-destroy-ui-logic';
import EntityDatasetUILogic from './entity-dataset-ui-logic';
import EventTestUILogic from './event-test-ui-logic';
import ParamsUILogic from './params-ui-logic';

/**
 * 图书UI服务对象基类
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%DE_PKGPATH%-ui-service-base.ts.ftl 生成
 * @export
 * @class IBIZBOOKUIServiceBase
 */
export default class IBIZBOOKUIServiceBase extends UIService {

    /**
     * 是否支持工作流
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public isEnableWorkflow:boolean = false;

    /**
     * 是否支持实体主状态
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public isEnableDEMainState:boolean = true;

    /**
     * 当前UI服务对应的数据服务对象
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */
    public dataService:IBIZBOOKService = new IBIZBOOKService();

    /**
     * 状态值
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public stateValue: number = 0;

    /**
     * 状态属性
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public stateField: string = "";

    /**
     * 主状态属性集合
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public mainStateFields:Array<any> = ['type'];

    /**
     * 主状态集合Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public allDeMainStateMap:Map<string,string> = new Map();

    /**
     * 主状态操作标识Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public allDeMainStateOPPrivsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  IBIZBOOKUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZBOOKUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.authService = new IBIZBOOKAuthService(opts);
        this.initViewMap();
        this.initDeMainStateMap();
        this.initDeMainStateOPPrivsMap();
    }

    /**
     * 初始化视图Map
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initViewMap(){
        this.allViewMap.set(':',{viewname:'treeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbooktree-view'});
        this.allViewMap.set(':',{viewname:'internalfuncgridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookinternal-func-grid-view'});
        this.allViewMap.set(':',{viewname:'gridexpview',viewType:'DEGRIDEXPVIEW',srfappde:'ibizbooks',component:'ibizbookgrid-exp-view'});
        this.allViewMap.set(':',{viewname:'gridloadcustomview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookgrid-load-custom-view'});
        this.allViewMap.set(':',{viewname:'haspanelkanbanview',viewType:'DEKANBANVIEW',srfappde:'ibizbooks',component:'ibizbookhas-panel-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'testcldataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbooktest-cldata-view'});
        this.allViewMap.set(':',{viewname:'usr6gridview_layout',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-grid-view-layout'});
        this.allViewMap.set(':',{viewname:'usr7gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr7-grid-view'});
        this.allViewMap.set(':',{viewname:'interfunctreeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbookinter-func-tree-view'});
        this.allViewMap.set(':',{viewname:'dashboardview',viewType:'DEPORTALVIEW',srfappde:'ibizbooks',component:'ibizbookdashboard-view'});
        this.allViewMap.set(':',{viewname:'usr4dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-data-view'});
        this.allViewMap.set(':',{viewname:'usr3customview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-custom-view'});
        this.allViewMap.set(':',{viewname:'editview4',viewType:'DEEDITVIEW4',srfappde:'ibizbooks',component:'ibizbookedit-view4'});
        this.allViewMap.set(':',{viewname:'testcltreeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbooktest-cltree-view'});
        this.allViewMap.set(':',{viewname:'usr2calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-calendar-view'});
        this.allViewMap.set(':',{viewname:'usr1110030546customview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookusr1110030546-custom-view'});
        this.allViewMap.set(':',{viewname:'formloadcustomview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookform-load-custom-view'});
        this.allViewMap.set(':',{viewname:'usr2listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-list-view'});
        this.allViewMap.set(':',{viewname:'usr4treeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-tree-view'});
        this.allViewMap.set(':',{viewname:'usr10editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr10-edit-view'});
        this.allViewMap.set(':',{viewname:'usr2editview_layout',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-edit-view-layout'});
        this.allViewMap.set(':',{viewname:'usr2pickupview',viewType:'DEPICKUPVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-pickup-view'});
        this.allViewMap.set(':',{viewname:'usr2optionview',viewType:'DEOPTVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-option-view'});
        this.allViewMap.set(':',{viewname:'valuerulesgridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookvalue-rules-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2meditview9',viewType:'DEMEDITVIEW9',srfappde:'ibizbooks',component:'ibizbookusr2-medit-view9'});
        this.allViewMap.set(':',{viewname:'interfunceditview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookinter-func-edit-view'});
        this.allViewMap.set(':',{viewname:'usr3treeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-tree-view'});
        this.allViewMap.set(':',{viewname:'usreditview_plugin',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr-edit-view-plugin'});
        this.allViewMap.set(':',{viewname:'usr7editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr7-edit-view'});
        this.allViewMap.set(':',{viewname:'usr4calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-calendar-view'});
        this.allViewMap.set(':',{viewname:'editview2',viewType:'DEEDITVIEW2',srfappde:'ibizbooks',component:'ibizbookedit-view2'});
        this.allViewMap.set(':',{viewname:'usr6calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-calendar-view'});
        this.allViewMap.set(':',{viewname:'wizardiwithstateview',viewType:'DEWIZARDVIEW',srfappde:'ibizbooks',component:'ibizbookwizard-iwith-state-view'});
        this.allViewMap.set(':',{viewname:'usr4gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-grid-view'});
        this.allViewMap.set(':',{viewname:'usr6gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-grid-view'});
        this.allViewMap.set(':',{viewname:'usr5calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookusr5-calendar-view'});
        this.allViewMap.set('EDITVIEW:',{viewname:'editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookedit-view'});
        this.allViewMap.set(':',{viewname:'interfunckanbanview_layout',viewType:'DEKANBANVIEW',srfappde:'ibizbooks',component:'ibizbookinter-func-kan-ban-view-layout'});
        this.allViewMap.set(':',{viewname:'usrgridview_colplugin',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr-grid-view-col-plugin'});
        this.allViewMap.set(':',{viewname:'usr3calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-calendar-view'});
        this.allViewMap.set(':',{viewname:'optionview',viewType:'DEOPTVIEW',srfappde:'ibizbooks',component:'ibizbookoption-view'});
        this.allViewMap.set(':',{viewname:'treegridexview',viewType:'DETREEGRIDEXVIEW',srfappde:'ibizbooks',component:'ibizbooktree-grid-ex-view'});
        this.allViewMap.set(':',{viewname:'roweditgridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookrow-edit-grid-view'});
        this.allViewMap.set(':',{viewname:'optionview_layout',viewType:'DEOPTVIEW',srfappde:'ibizbooks',component:'ibizbookoption-view-layout'});
        this.allViewMap.set(':',{viewname:'interfunceditview_layout',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookinter-func-edit-view-layout'});
        this.allViewMap.set(':',{viewname:'testclcalendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbooktest-clcalendar-view'});
        this.allViewMap.set(':',{viewname:'usreditview_ctrlplugin',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr-edit-view-ctrl-plugin'});
        this.allViewMap.set(':',{viewname:'testcllistview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbooktest-cllist-view'});
        this.allViewMap.set(':',{viewname:'usr2meditview9_layout',viewType:'DEMEDITVIEW9',srfappde:'ibizbooks',component:'ibizbookusr2-medit-view9-layout'});
        this.allViewMap.set(':',{viewname:'usrtreeview_plugin',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbookusr-tree-view-plugin'});
        this.allViewMap.set(':',{viewname:'usr7listview_listplugin',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr7-list-view-list-plugin'});
        this.allViewMap.set(':',{viewname:'usr3editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-edit-view'});
        this.allViewMap.set(':',{viewname:'groupbycodelistkanbanview',viewType:'DEKANBANVIEW',srfappde:'ibizbooks',component:'ibizbookgroup-by-codelist-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'usr6listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-list-view'});
        this.allViewMap.set(':',{viewname:'exportandimportgridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookexport-and-import-grid-view'});
        this.allViewMap.set(':',{viewname:'autogrouplistview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookauto-group-list-view'});
        this.allViewMap.set(':',{viewname:'usr3listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-list-view'});
        this.allViewMap.set(':',{viewname:'meditview9',viewType:'DEMEDITVIEW9',srfappde:'ibizbooks',component:'ibizbookmedit-view9'});
        this.allViewMap.set(':',{viewname:'usr2treeview',viewType:'DETREEVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-tree-view'});
        this.allViewMap.set('REDIRECTVIEW:',{viewname:'redirectview',viewType:'DEREDIRECTVIEW',srfappde:'ibizbooks',component:'ibizbookredirect-view'});
        this.allViewMap.set(':',{viewname:'usr2pickuptreeview',viewType:'DEPICKUPTREEVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-pickup-tree-view'});
        this.allViewMap.set(':',{viewname:'customview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookcustom-view'});
        this.allViewMap.set(':',{viewname:'usr4listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-list-view'});
        this.allViewMap.set(':',{viewname:'ganttview',viewType:'DEGANTTVIEW',srfappde:'ibizbooks',component:'ibizbookgantt-view'});
        this.allViewMap.set(':',{viewname:'usr2dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-data-view'});
        this.allViewMap.set(':',{viewname:'dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookdata-view'});
        this.allViewMap.set(':',{viewname:'usrwizardview_plugin',viewType:'DEWIZARDVIEW',srfappde:'ibizbooks',component:'ibizbookusr-wizard-view-plugin'});
        this.allViewMap.set(':',{viewname:'usr6dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-data-view'});
        this.allViewMap.set(':',{viewname:'dataviewexpview',viewType:'DEDATAVIEWEXPVIEW',srfappde:'ibizbooks',component:'ibizbookdata-view-exp-view'});
        this.allViewMap.set(':',{viewname:'newdefaultvaluegridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbooknew-default-value-grid-view'});
        this.allViewMap.set('PICKUPVIEW:',{viewname:'pickupview',viewType:'DEPICKUPVIEW',srfappde:'ibizbooks',component:'ibizbookpickup-view'});
        this.allViewMap.set(':',{viewname:'usr3dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-data-view'});
        this.allViewMap.set(':',{viewname:'usr5editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr5-edit-view'});
        this.allViewMap.set(':',{viewname:'wizardview',viewType:'DEWIZARDVIEW',srfappde:'ibizbooks',component:'ibizbookwizard-view'});
        this.allViewMap.set(':',{viewname:'usr5listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr5-list-view'});
        this.allViewMap.set(':',{viewname:'usrgridview_plugin',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr-grid-view-plugin'});
        this.allViewMap.set(':',{viewname:'usroptionview',viewType:'DEOPTVIEW',srfappde:'ibizbooks',component:'ibizbookusr-option-view'});
        this.allViewMap.set(':',{viewname:'wizardview_layout',viewType:'DEWIZARDVIEW',srfappde:'ibizbooks',component:'ibizbookwizard-view-layout'});
        this.allViewMap.set(':',{viewname:'interfunckanbanview',viewType:'DEKANBANVIEW',srfappde:'ibizbooks',component:'ibizbookinter-func-kan-ban-view'});
        this.allViewMap.set(':',{viewname:'usrgridview_ctrlplugin',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr-grid-view-ctrl-plugin'});
        this.allViewMap.set(':',{viewname:'usr2customview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-custom-view'});
        this.allViewMap.set(':',{viewname:'panelview',viewType:'DEPANELVIEW',srfappde:'ibizbooks',component:'ibizbookpanel-view'});
        this.allViewMap.set(':',{viewname:'haspanellistview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookhas-panel-list-view'});
        this.allViewMap.set(':',{viewname:'usr10gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr10-grid-view'});
        this.allViewMap.set(':',{viewname:'calendarview',viewType:'DECALENDARVIEW',srfappde:'ibizbooks',component:'ibizbookcalendar-view'});
        this.allViewMap.set(':',{viewname:'usrlistview_plugin',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr-list-view-plugin'});
        this.allViewMap.set(':',{viewname:'updatedefaultgridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookupdate-default-grid-view'});
        this.allViewMap.set(':',{viewname:'usrpickupview_plugin',viewType:'DEPICKUPVIEW',srfappde:'ibizbooks',component:'ibizbookusr-pickup-view-plugin'});
        this.allViewMap.set(':',{viewname:'usr8editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr8-edit-view'});
        this.allViewMap.set(':',{viewname:'listview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbooklist-view'});
        this.allViewMap.set(':',{viewname:'ruleseditview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookrules-edit-view'});
        this.allViewMap.set(':',{viewname:'pickupgridview',viewType:'DEPICKUPGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookpickup-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-edit-view'});
        this.allViewMap.set(':',{viewname:'testlogiccustomview',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbooktest-logic-custom-view'});
        this.allViewMap.set(':',{viewname:'usr4listview_layout',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-list-view-layout'});
        this.allViewMap.set(':',{viewname:'usr5dataview',viewType:'DEDATAVIEW',srfappde:'ibizbooks',component:'ibizbookusr5-data-view'});
        this.allViewMap.set(':',{viewname:'pickuptreeview',viewType:'DEPICKUPTREEVIEW',srfappde:'ibizbooks',component:'ibizbookpickup-tree-view'});
        this.allViewMap.set(':',{viewname:'usr3gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr3-grid-view'});
        this.allViewMap.set(':',{viewname:'uiactiongridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookui-action-grid-view'});
        this.allViewMap.set(':',{viewname:'usr4editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr4-edit-view'});
        this.allViewMap.set(':',{viewname:'editview3',viewType:'DEEDITVIEW3',srfappde:'ibizbooks',component:'ibizbookedit-view3'});
        this.allViewMap.set(':',{viewname:'usr5gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr5-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr2-grid-view'});
        this.allViewMap.set(':',{viewname:'groupbycodelistlistview',viewType:'DELISTVIEW',srfappde:'ibizbooks',component:'ibizbookgroup-by-codelist-list-view'});
        this.allViewMap.set(':',{viewname:'usr8gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr8-grid-view'});
        this.allViewMap.set(':',{viewname:'usreditview_actionplugin',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr-edit-view-action-plugin'});
        this.allViewMap.set(':',{viewname:'treeexpview',viewType:'DETREEEXPVIEW',srfappde:'ibizbooks',component:'ibizbooktree-exp-view'});
        this.allViewMap.set(':',{viewname:'customview_layout',viewType:'DECUSTOMVIEW',srfappde:'ibizbooks',component:'ibizbookcustom-view-layout'});
        this.allViewMap.set(':',{viewname:'usr9gridview',viewType:'DEGRIDVIEW',srfappde:'ibizbooks',component:'ibizbookusr9-grid-view'});
        this.allViewMap.set(':',{viewname:'dashboardview_layout',viewType:'DEPORTALVIEW',srfappde:'ibizbooks',component:'ibizbookdashboard-view-layout'});
        this.allViewMap.set(':',{viewname:'usr9editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr9-edit-view'});
        this.allViewMap.set(':',{viewname:'usr6editview',viewType:'DEEDITVIEW',srfappde:'ibizbooks',component:'ibizbookusr6-edit-view'});
    }

    /**
     * 初始化主状态集合
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initDeMainStateMap(){
        this.allDeMainStateMap.set('仙侠','仙侠');
        this.allDeMainStateMap.set('都市','都市');
        this.allDeMainStateMap.set('武侠','武侠');
    }

    /**
     * 初始化主状态操作标识
     * 
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public initDeMainStateOPPrivsMap(){
        this.allDeMainStateOPPrivsMap.set('仙侠',Object.assign({'CREATE':1,'DELETE':1,'EDIT':1,'OPEN_DOCUMENT':1,'READ':1,'UPDATE':1},{'DELETE':0,}));
        this.allDeMainStateOPPrivsMap.set('都市',Object.assign({'CREATE':1,'DELETE':1,'EDIT':1,'OPEN_DOCUMENT':1,'READ':1,'UPDATE':1},{'EDIT':0,}));
        this.allDeMainStateOPPrivsMap.set('武侠',Object.assign({'CREATE':1,'DELETE':1,'EDIT':1,'OPEN_DOCUMENT':1,'READ':1,'UPDATE':1},{'OPEN_DOCUMENT':0,}));
    }

        /**
     * 导出测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_DataExportTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        if (!xData || !(xData.exportExcel instanceof Function) || !$event) {
            return;
        }
        xData.exportExcel({ maxRowCount: 1000 });
    }

        /**
     * 导入测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_DataImportTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const view: any = {
            viewname: 'app-data-upload',
            title: actionContext.$t("app.utilview.importview"),
            width: 544,
            height: 368,
            customClass: 'app-data-upload-modal view-default'
        }
        if (actionContext.context && actionContext.context.srfparentdename && actionContext.context.srfparentkey) {
            Object.assign(context, { srfparentdename: actionContext.context.srfparentdename });
            Object.assign(context, { srfparentkey: actionContext.context.srfparentkey });
        } else {
            if (context.srfparentdename) {
                delete context.srfparentdename;
            }
            if (context.srfparentkey) {
                delete context.srfparentkey;
            }
        }
        const container: Subject<any> = actionContext.$appmodal.openModal(view, context, Object.assign({
            importId: 'DataImport',
            serviceName: 'IBIZBOOK',
            appDeLogicName: '图书',
            ignoreError: false,
            importData: {
                'AUTHOR': {
                    headername: '图书作者',
                    isuniqueitem: false,
                    name: "author",
                    order: 1000
                },
                'BOOKNUMBER': {
                    headername: '图书数量',
                    isuniqueitem: false,
                    name: "booknumber",
                    order: 1000
                },
                'BORROWWAY': {
                    codeList: { tag: 'CodeList25', type: 'STATIC' },
                    headername: '借阅方式',
                    isuniqueitem: false,
                    name: "borrowway",
                    order: 1000
                },
                'IBIZBOOKID': {
                    headername: '图书标识',
                    isuniqueitem: false,
                    name: "ibizbookid",
                    order: 1000
                },
                'IBIZBOOKNAME': {
                    headername: '图书名称',
                    isuniqueitem: false,
                    name: "ibizbookname",
                    order: 1000
                },
                'PRESS': {
                    headername: '图书出版社',
                    isuniqueitem: false,
                    name: "press",
                    order: 1000
                },
                'PRICE': {
                    headername: '图书价格',
                    isuniqueitem: false,
                    name: "price",
                    order: 1000
                },
                'SAILSTATE': {
                    codeList: { tag: 'BookSailState', type: 'STATIC' },
                    headername: '图书销售状态',
                    isuniqueitem: false,
                    name: "sailstate",
                    order: 1000
                },
                'SUBTEXT': {
                    headername: '图书描述',
                    isuniqueitem: false,
                    name: "subtext",
                    order: 1000
                },
                'TAG': {
                    headername: '标签',
                    isuniqueitem: false,
                    name: "tag",
                    order: 1000
                },
                'TYPE': {
                    codeList: { tag: 'BookType', type: 'STATIC' },
                    headername: '图书类型',
                    isuniqueitem: false,
                    name: "type",
                    order: 1000
                }
            }
            
        }, tempViewParam));
        container.subscribe((result: any) => {
            if (Object.is(result.ret, 'OK')) {
                actionContext.refresh(result.datas);
            }
        });
    }

        /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_Delete(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        data = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        if (Object.is(actionTarget, "MULTIKEY")) {
            let tempDataArray:Array<any> = [];
            if ((_args.length > 1) && (Object.keys(data).length > 0)) {
                for(let i =0; i < _args.length; i++){
                    let tempObject: any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{ [key]: data[key].split(',')[i] });
                    })
                    tempDataArray.push(tempObject);
                }
            } else {
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        Object.assign(context, tempContext);
        let parentObj: any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data, parentObj);
        }
        Object.assign(context, parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
            context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            if (xData && xData.formValidateStatus instanceof Function) {
                if (!xData.formValidateStatus()) {
                    actionContext.$Notice.error({ title: '错误', desc: actionContext.$t('app.searchform.globalerrortip') as string });
                    return;
                }
            }
            const curService: IBIZBOOKService =  new IBIZBOOKService();
            let promise: any = curService['Remove'](context, data);
            promise.then(async (response: any) => {
                if ((!response || response.status !== 200) && !Array.isArray(response)) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                let { data } = response;
                if (Array.isArray(response) && response.length > 0) {
                    data = [];
                    response.forEach((item: any) => {
                        data.push(item.data);
                    })
                }
                actionContext.$Notice.success({ title: '成功', desc: '删除成功！' });
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

        /**
     * 编辑
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_Edit(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'usr3editview', parameterName: 'usr3editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 打印测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_PrintTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
                console.log('暂未支持打印');
    }

        /**
     * 自定义测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_TestCustom(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const executeScriptCode = () => {
            const data = args;
            eval(`console.log(data);`);
        }
        return executeScriptCode();
    }

        /**
     * 实体行为与界面行为
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_actiontest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('actiontest', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

    /**
     * 弹出消息
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIServiceBase
     */
    public async IBIZBOOK_alertMessage(args: any[], context:any = {}, params:any = {}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string) {
        //  自定义代码
    }
        /**
     * 实体数据集或异常
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_entitydataset(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('entityDataset', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

        /**
     * 事件调用与事件触发
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_eventtest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('eventTest', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

        /**
     * 多项数据（主键）测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_multiDataKeyTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'MULTIKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 多项数据测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_mutliDataTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'MULTIDATA';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 无数据测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_noDataTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 打开自定义编辑视图
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_openCustomEditView(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'formloadcustomview', parameterName: 'formloadcustomview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 打开文档
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_openDocument(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return { ok: true, result: _args };
        }
        const url = `https://www.yuque.com/ibiz/wuf19n`;
        return openPopupApp(url);
    }

        /**
     * 打开实体看板文档
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_openKanbanDocument(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return { ok: true, result: _args };
        }
        const url = `https://www.yuque.com/ibiz/wuf19n/tqi7p6`;
        return openPopupApp(url);
    }

        /**
     * 编辑
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_panel_Usr1109586119_button_calluilogic2_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('CustomEdit', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

        /**
     * 页面链接
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_panel_Usr1215247253_button_link1_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEDATA';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempData = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(data, tempData);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return { ok: true, result: _args };
        }
        const url = `https://www.baidu.com/`;
        return openPopupApp(url);
    }

        /**
     * 图书
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_panel_Usr1215247253_button_openview1_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEDATA';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempData = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(data, tempData);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'usr9editview', parameterName: 'usr9editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 准备参数
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_params(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('params', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

        /**
     * 单项数据测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_singleDataTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEDATA';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempData = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(data, tempData);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 单项数据（主键）测试
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_singleKeyTest(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizbookid']) {
            Object.assign(tempContext, { ibizbook: '%ibizbookid%' });
        } else {
            Object.assign(tempContext, { ibizbook: '%ibizbook%' });
        }
        Object.assign(tempViewParam, { ibizbookid: '%ibizbook%' });
        Object.assign(tempViewParam, { ibizbookname: '%ibizbookname%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizbooks', parameterName: 'ibizbook' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 加载
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZBOOKUIService
     */
    public async IBIZBOOK_toolbar_CustomView_layouttoolbar_deuiaction1_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('GridLoad', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }


    /**
     * 获取指定数据的重定向页面
     * 
     * @param srfkey 数据主键
     * @param isEnableWorkflow  重定向视图是否需要处理流程中的数据
     * @param args  {context,viewParams} 用于计算流程   
     * @memberof  IBIZBOOKUIServiceBase
     */
    public async getRDAppView(srfkey:string,isEnableWorkflow:boolean,args?:any){
        this.isEnableWorkflow = isEnableWorkflow;
        // 进行数据查询
        let result:any = await this.dataService.Get({ibizbook:srfkey});
        const curData:any = result.data;
        //判断当前数据模式,默认为true，todo
        const iRealDEModel:boolean = true;
        let bDataInWF:boolean = false;
		let bWFMode:any = false;
		if (this.isEnableWorkflow) {
            return this.getWFView();
        } else {
            if ((args && args.viewParam && args.viewParam.srfwf && this.InWorkflowArray.indexOf(args.viewParam.srfwf) !== -1)) {
                return this.getWFView();
            }
        }
        let strPDTViewParam:string = await this.getDESDDEViewPDTParam(curData, bDataInWF, bWFMode);
        return this.allViewMap.get(strPDTViewParam);
    }

    /**
	 * 获取实际的数据类型
     * 
     * @memberof  IBIZBOOKUIServiceBase
	 */
	public getRealDEType(entity:any){

    }

    /**
     * 获取实体单数据实体视图预定义参数
     * 
     * @param curData 当前数据
     * @param bDataInWF 是否有数据在工作流中
     * @param bWFMode   是否工作流模式
     * @memberof  IBIZBOOKUIServiceBase
     */
    public async getDESDDEViewPDTParam(curData:any, bDataInWF:boolean, bWFMode:boolean){
        let strPDTParam:string = '';
		if (bDataInWF) {
			// 判断数据是否在流程中
        }
        //多表单，todo
        const multiFormDEField:string|null =null;

        if (multiFormDEField) {
			const objFormValue:string = curData[multiFormDEField];
			if(!Environment.isAppMode){
				return 'MOBEDITVIEW:'+objFormValue;
			}
			return 'EDITVIEW:'+objFormValue;
        }
		if(!Environment.isAppMode){
            if(this.getDEMainStateTag(curData)){
                return `MOBEDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
            }
			return 'MOBEDITVIEW:';
        }
        if(this.getDEMainStateTag(curData)){
            return `EDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
        }
		return 'EDITVIEW:';
    }

    /**
     * 获取数据对象的主状态标识
     * 
     * @param curData 当前数据
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public getDEMainStateTag(curData:any){
        if(this.mainStateFields.length === 0) return null;

        this.mainStateFields.forEach((singleMainField:any) =>{
            if(!(singleMainField in curData)){
                console.warn(`当前数据对象不包含属性「${singleMainField}」，根据「${singleMainField}」属性进行的主状态计算默认为空值`);
            }
        })
        for (let i = 0; i <= 1; i++) {
            let strTag:string = (curData[this.mainStateFields[0]] != null && curData[this.mainStateFields[0]] !== "")?(i == 0) ? `${curData[this.mainStateFields[0]]}` : "":"";
            if (this.mainStateFields.length >= 2) {
                for (let j = 0; j <= 1; j++) {
                    let strTag2:string = (curData[this.mainStateFields[1]] != null && curData[this.mainStateFields[1]] !== "")?`${strTag}__${(j == 0) ? `${curData[this.mainStateFields[1]]}` : ""}`:strTag;
                    if (this.mainStateFields.length >= 3) {
                        for (let k = 0; k <= 1; k++) {
                            let strTag3:string = (curData[this.mainStateFields[2]] != null && curData[this.mainStateFields[2]] !== "")?`${strTag2}__${(k == 0) ? `${curData[this.mainStateFields[2]]}` : ""}`:strTag2;
                            // 判断是否存在
                            return this.allDeMainStateMap.get(strTag3);
                        }
                    }else{
                        return this.allDeMainStateMap.get(strTag2);
                    }
                }
            }else{
                return this.allDeMainStateMap.get(strTag);
            }
        }
        return null;
    }

    /**
     * 获取数据对象当前操作标识
     * 
     * @param data 当前数据
     * @memberof  IBIZBOOKUIServiceBase
     */  
    public getDEMainStateOPPrivs(data:any){
        if(this.getDEMainStateTag(data)){
            return this.allDeMainStateOPPrivsMap.get((this.getDEMainStateTag(data) as string));
        }else{
            return null;
        }
    }

    /**
     * 获取数据对象所有的操作标识
     * 
     * @param data 当前数据
     * @memberof  IBIZBOOKUIServiceBase
     */ 
    public getAllOPPrivs(data:any){
       return this.authService.getOPPrivs(this.getDEMainStateOPPrivs(data));
    }

    /**
     * 执行界面逻辑
     *
     * @param {string} name
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof UIService
     */
    public async executeUILogic(name: string, args: any[], context?: any, params?: any, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string | undefined): Promise<any> {
        //  转化参数
        let data: any = null;
        if (args && Array.isArray(args) && args.length > 0) {
            data = args[0];
        } else {
            data = (Object.keys(args).length > 0) ? args : {};
        }
        if (name === 'CustomEdit') {
            return await CustomEditUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'CustomViewFormLoad') {
            return await CustomViewFormLoadUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'CustomViewGridLoad') {
            return await CustomViewGridLoadUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'FormLoad') {
            return await FormLoadUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'GridLoad') {
            return await GridLoadUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'PrintParams') {
            return await PrintParamsUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'actiontest') {
            return await ActiontestUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'cancelSelect') {
            return await CancelSelectUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'customViewDestroy') {
            return await CustomViewDestroyUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'entityDataset') {
            return await EntityDatasetUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'eventTest') {
            return await EventTestUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'params') {
            return await ParamsUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
    } 

}