import { PanelDetailModel } from './panel-detail';

/**
 * 面板容器模型
 *
 * @export
 * @class PanelContainerModel
 * @extends {PanelDetailModel}
 */
export class PanelContainerModel extends PanelDetailModel {

    /**
     * 子项
     *
     * @type {string[]}
     * @memberof PanelContainerModel
     */
    public details: string[] = [];

    /**
     * 标题关闭模式
     *
     * @type {number}
     * @memberof PanelContainerModel
     */
    public titleBarCloseMode: number = 0;

    /**
     * 背景图片
     *
     * @type {*}
     * @memberof PanelContainerModel
     */
    public sysImage: any = {};

    /**
     * 应用实体codeName
     *
     * @type {(string | undefined)}
     * @memberof PanelContainerModel
     */
    public appDataEntityCodeName:string | undefined = undefined;

    /**
     * 应用实体方法CodeName
     *
     * @type {(string | undefined)}
     * @memberof PanelContainerModel
     */
    public appDEMethodCodeName:string | undefined = undefined;

    /**
     * Creates an instance of PanelContainerModel.
     * @param {*} [opts={}]
     * @memberof PanelContainerModel
     */
    public constructor(opts: any = {}) {
        super(opts);
        this.details = opts.details;
        this.titleBarCloseMode = opts.titleBarCloseMode;
        this.sysImage = opts.sysImage;
        this.appDataEntityCodeName = opts.appDataEntityCodeName;
        this.appDEMethodCodeName = opts.appDEMethodCodeName;
    }

    /**
     * 获取容器元素样式(仅限容器元素)
     *
     * @return {*} 
     * @memberof PanelContainerModel
     */
    public getElementStyle() {
        const containerStyle = {};
        Object.assign(containerStyle, this.getFlexStyle());
        //边缘布局容器盒子大小由布局组件内部计算
        if (this.layout !== "BORDER") {
            Object.assign(containerStyle, this.getBoxSizeStyle());
        }
        Object.assign(containerStyle, this.getBoxSpacingStyle());
        Object.assign(containerStyle, this.getSpecificStyle());
        return containerStyle;
    }

    /**
     * 获取容器特有样式（主要包含背景图片）
     *
     * @protected
     * @memberof PanelContainerModel
     */
    protected getSpecificStyle() {
        const boxStyle = {};
        if (Object.is(this.itemStyle, 'STYLE2') && this.sysImage && (this.sysImage.imagePath || this.sysImage.rawContent)) {
            Object.assign(boxStyle, { background: `url('${this.sysImage.imagePath || this.sysImage.rawContent}') no-repeat 0px 0px`, 'background-size': '100% 100%' });
            if (!this.layoutWidth) {
                Object.assign(boxStyle, { width: '100%' });
            }
            if (!this.layoutHeight) {
                Object.assign(boxStyle, { height: '100%' });
            }
        }
        return boxStyle;
    }


}