/**
 * Booklist 部件模型
 *
 * @export
 * @class BooklistModel
 */
export default class BooklistModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof BooklistDashboard_sysportlet2_listMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'srfmajortext',
				prop: 'ibizbookname',
				dataType: 'TEXT',
			},
			{
				name: 'srfdescription',
				prop: 'subtext',
				dataType: 'TEXT',
			},
			{
				name: 'srfdate',
				prop: 'lendouttime',
				dataType: 'DATE',
			},
			{
				name: 'srficon',
				prop: 'icon',
				dataType: 'LONGTEXT',
			},
			{
				name: 'srfkey',
				prop: 'ibizbookid',
				dataType: 'GUID',
			},
			{
				name: 'srfmstag',
			},
			{
				name: 'ibizbook',
				prop: 'ibizbookid',
				dataType: 'FONTKEY',
			},
      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}