import { Http,Util } from '@/utils';
import OpenYuQueUILogicBase from './open-yu-que-ui-logic-base';

/**
 * 打开语雀文档
 *
 * @export
 * @class OpenYuQueUILogic
 */
export default class OpenYuQueUILogic extends OpenYuQueUILogicBase {

    /**
     * 打开语雀文档 逻辑实例对象
     *
     * @private
     * @static
     * @type {OpenYuQueUILogic}
     * @memberof OpenYuQueUILogic
     */
    private static instance: OpenYuQueUILogic;

    /**
     * 获取 打开语雀文档 逻辑实例对象
     *
     * @static
     * @return {*}  {OpenYuQueUILogic}
     * @memberof OpenYuQueUILogic
     */
    static getInstance(): OpenYuQueUILogic {
        if (!this.instance) {
            this.instance = new OpenYuQueUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  OpenYuQueUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  OpenYuQueUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}