import { Http,Util } from '@/utils';
import GridViewLoadUILogicBase from './grid-view-load-ui-logic-base';

/**
 * 自定义表格数据加载
 *
 * @export
 * @class GridViewLoadUILogic
 */
export default class GridViewLoadUILogic extends GridViewLoadUILogicBase {

    /**
     * 自定义表格数据加载 逻辑实例对象
     *
     * @private
     * @static
     * @type {GridViewLoadUILogic}
     * @memberof GridViewLoadUILogic
     */
    private static instance: GridViewLoadUILogic;

    /**
     * 获取 自定义表格数据加载 逻辑实例对象
     *
     * @static
     * @return {*}  {GridViewLoadUILogic}
     * @memberof GridViewLoadUILogic
     */
    static getInstance(): GridViewLoadUILogic {
        if (!this.instance) {
            this.instance = new GridViewLoadUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  GridViewLoadUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  GridViewLoadUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}