import { Http,Util } from '@/utils';
import CancelSelectUILogicBase from './cancel-select-ui-logic-base';

/**
 * 取消选中（选中返回false）
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class CancelSelectUILogic
 */
export default class CancelSelectUILogic extends CancelSelectUILogicBase {

    /**
     * 取消选中（选中返回false） 逻辑实例对象
     *
     * @private
     * @static
     * @type {CancelSelectUILogic}
     * @memberof CancelSelectUILogic
     */
    private static instance: CancelSelectUILogic;

    /**
     * 获取 取消选中（选中返回false） 逻辑实例对象
     *
     * @static
     * @return {*}  {CancelSelectUILogic}
     * @memberof CancelSelectUILogic
     */
    static getInstance(): CancelSelectUILogic {
        if (!this.instance) {
            this.instance = new CancelSelectUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  CancelSelectUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  CancelSelectUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}