import ViewMessageService from '../view-message-service';
/**
 * 临时模式视图消息视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg97MessageServiceBase
 */
export default class ViewMsg97MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg97MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg97MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg97MessageServiceBase
     */
    public initBasicParam(){
        this.id = "d6f6c575e034505b39359ea5bf164a1b";
        this.name = "临时模式视图消息";
        this.codename = "ViewMsg97";
        this.title = "";
        this.content = "此示例展示临时模式。适用于带有主从业务关系数据的整体提交的场景。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg97MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}