import ViewMessageService from '../view-message-service';
/**
 * 前台界面行为视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg92MessageServiceBase
 */
export default class ViewMsg92MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg92MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg92MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg92MessageServiceBase
     */
    public initBasicParam(){
        this.id = "52923cf65de9f724be521cf43c3c68cc";
        this.name = "前台界面行为";
        this.codename = "ViewMsg92";
        this.title = "";
        this.content = "本示例展示前台界面行为：如打开编辑视图。若无选中数据则根据配置的上下文参数跳转到相应数据的编辑视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg92MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}