import ViewMessageService from '../view-message-service';
/**
 * 柱状图视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg77MessageServiceBase
 */
export default class ViewMsg77MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg77MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg77MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg77MessageServiceBase
     */
    public initBasicParam(){
        this.id = "7728f5443b47f2bfaa0e7701efc7e6ae";
        this.name = "柱状图";
        this.codename = "ViewMsg77";
        this.title = "";
        this.content = "本示例展示订单金额柱状图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg77MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}