import ViewMessageService from '../view-message-service';
/**
 * 表格主状态视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg59MessageServiceBase
 */
export default class ViewMsg59MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg59MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg59MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg59MessageServiceBase
     */
    public initBasicParam(){
        this.id = "04293638969b47b30cfb18182bf304d5";
        this.name = "表格主状态";
        this.codename = "ViewMsg59";
        this.title = "";
        this.content = "本示例展示表格主状态（通过主状态控制操作列状态）：图书类型为都市时禁用编辑，类型为仙侠时禁用删除，点击编辑时可进入编辑表单主状态展示。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg59MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}