import ViewMessageService from '../view-message-service';
/**
 * 实体看板---内置功能视图消息服务对象基类
 * 基于 APP/src/message/%APP_MSG%/%APP_MSG%-message-base.ts.ftl 生成
 * @export
 * @class ViewMsg58MessageServiceBase
 */
export default class ViewMsg58MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg58MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg58MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg58MessageServiceBase
     */
    public initBasicParam(){
        this.id = "10dacadc6aca5601a8286102a85d6223";
        this.name = "实体看板---内置功能";
        this.codename = "ViewMsg58";
        this.title = "";
        this.content = "本示例展示实体看板内置功能：包括自动分组，分组界面行为，拖动修改数据分组属性等功能。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg58MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}