/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'ibizuniproductname',
          prop: 'ibizuniproductname',
          dataType: 'TEXT',
        },
        {
          name: 'ibizuniproducttype',
          prop: 'ibizuniproducttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'unit',
          prop: 'unit',
          dataType: 'TEXT',
        },
        {
          name: 'unitprice',
          prop: 'unitprice',
          dataType: 'FLOAT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'ibizuniproductid',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizuniproductid',
          dataType: 'GUID',
        },
        {
          name: 'srfdatatype',
          prop: 'ibizuniproducttype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizuniproductname',
          dataType: 'TEXT',
        },
        {
          name: 'ibizuniproduct',
          prop: 'ibizuniproductid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
        // 预置工作流数据字段
        {
          name: 'srfprocessdefinitionkey',
          prop: 'srfprocessdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskdefinitionkey',
          prop: 'srftaskdefinitionkey',
          dataType: 'TEXT'
        },
        {
          name: 'srftaskid',
          prop: 'srftaskid',
          dataType: 'TEXT'
        }
      ]
    }
  }

}