import { Http,Util } from '@/utils';
import CustomEditUILogicBase from './custom-edit-ui-logic-base';

/**
 * 编辑
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic.ts.ftl 生成
 * @export
 * @class CustomEditUILogic
 */
export default class CustomEditUILogic extends CustomEditUILogicBase {

    /**
     * 编辑 逻辑实例对象
     *
     * @private
     * @static
     * @type {CustomEditUILogic}
     * @memberof CustomEditUILogic
     */
    private static instance: CustomEditUILogic;

    /**
     * 获取 编辑 逻辑实例对象
     *
     * @static
     * @return {*}  {CustomEditUILogic}
     * @memberof CustomEditUILogic
     */
    static getInstance(): CustomEditUILogic {
        if (!this.instance) {
            this.instance = new CustomEditUILogic();
        }
        return this.instance;
    }

    /**
     * Creates an instance of  CustomEditUILogic
     * 
     * @param {*} [opts={}]
     * @memberof  CustomEditUILogic
     */
    constructor(opts: any = {}) {
        super(opts);
    }

}