package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZTASKTEAM;
import cn.ibizlab.core.sample.service.IBIZTASKTEAMService;
import cn.ibizlab.core.sample.filter.IBIZTASKTEAMSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"任务团队" })
@RestController("demoapi-ibiztaskteam")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZTASKTEAMResource {

    @Autowired
    public IBIZTASKTEAMService ibiztaskteamService;

    @Autowired
    @Lazy
    public IBIZTASKTEAMDTOMapping ibiztaskteamdtoMapping;



    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZTASKTEAM-Create-all')")
    @ApiOperation(value = "批量新建任务团队", tags = {"任务团队" },  notes = "批量新建任务团队")
	@RequestMapping(method = RequestMethod.POST, value = "ibiztaskteams/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZTASKTEAMDTO> dtos) {
        ibiztaskteamService.createBatch(ibiztaskteamdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZTASKTEAM-Update-all')")
    @ApiOperation(value = "批量更新任务团队", tags = {"任务团队" },  notes = "批量更新任务团队")
	@RequestMapping(method = RequestMethod.PUT, value = "ibiztaskteams/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZTASKTEAMDTO> dtos) {
        ibiztaskteamService.updateBatch(ibiztaskteamdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZTASKTEAM-Save-all')")
    @ApiOperation(value = "批量保存任务团队", tags = {"任务团队" },  notes = "批量保存任务团队")
	@RequestMapping(method = RequestMethod.POST, value = "ibiztaskteams/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZTASKTEAMDTO> dtos) {
        ibiztaskteamService.saveBatch(ibiztaskteamdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZTASKTEAM-Save-all')")
    @ApiOperation(value = "批量导入任务团队", tags = {"任务团队" },  notes = "批量导入任务团队")
	@RequestMapping(method = RequestMethod.POST, value = "ibiztaskteams/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZTASKTEAMDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZTASKTEAM> list=ibiztaskteamdtoMapping.toDomain(dtos);
            List<IBIZTASKTEAM> rtList=new ArrayList();
            list.forEach(item->{
                if(ibiztaskteamService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZTASKTEAM-Remove-all')")
    @ApiOperation(value = "批量删除任务团队", tags = {"任务团队" },  notes = "批量删除任务团队")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibiztaskteams","/ibiztaskteams/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibiztaskteamService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
