package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.filter.IBIZSample0012SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0012Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0012Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[订单] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0012Service")
public class IBIZSample0012ServiceBase extends ServiceImpl<IBIZSample0012Mapper,IBIZSample0012> implements IBIZSample0012Service {


    protected int batchSize = 500;

    public IBIZSample0012 get(IBIZSample0012 et) {
        IBIZSample0012 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,订单:"+et.getIbizSample0012Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0012> getByEntities(List<IBIZSample0012> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZSample0012 getDraft(IBIZSample0012 et) {
        return et;
    }

    public Integer checkKey(IBIZSample0012 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0012Id())) && this.count(Wrappers.<IBIZSample0012>query().eq("ibizsample0012id", et.getIbizSample0012Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0012 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0012> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0012 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0012id", et.getIbizSample0012Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0012> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0012 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0012> list) {
        List<IBIZSample0012> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0012Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0012> _create=new ArrayList<>();
        List<IBIZSample0012> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0012Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0012 et) {
        String key = et.getIbizSample0012Id();

        if(!remove(new QueryWrapper<IBIZSample0012>()
                .eq("ibizsample0012id", et.getIbizSample0012Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0012> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0012> searchDefault(IBIZSample0012SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0012> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0012>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0012> listDefault(IBIZSample0012SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}