package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0017;
import cn.ibizlab.core.sample.filter.IBIZSample0017SearchContext;

public interface IBIZSample0017Service extends IService<IBIZSample0017> {

    default IBIZSample0017Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0017 get(IBIZSample0017 et);
    default IBIZSample0017 get(String key) {
        IBIZSample0017 et = new IBIZSample0017();
        et.setIbizSample0017Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0017> getByIds(Collection<String> ids) {
        List<IBIZSample0017> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0017 et = new IBIZSample0017();
            et.setIbizSample0017Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0017> getByEntities(List<IBIZSample0017> entities);

    IBIZSample0017 getDraft(IBIZSample0017 et);

    Integer checkKey(IBIZSample0017 et);

    boolean create(IBIZSample0017 et);
    boolean createBatch(List<IBIZSample0017> list);

    boolean update(IBIZSample0017 et);
    boolean updateBatch(List<IBIZSample0017> list);

    boolean save(IBIZSample0017 et);
    boolean saveBatch(List<IBIZSample0017> list);

    default boolean remove(String key) {
        IBIZSample0017 et = new IBIZSample0017();
        et.setIbizSample0017Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0017 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0017> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0017 et = new IBIZSample0017();
            et.setIbizSample0017Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0017> entities);

    Page<IBIZSample0017> searchDefault(IBIZSample0017SearchContext context);
    List<IBIZSample0017> listDefault(IBIZSample0017SearchContext context);

    default IBIZSample0017SearchContext getSearchContext() {
        return new IBIZSample0017SearchContext();
    }

    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}