package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0020;
/**
 * 关系型数据实体[IBIZSample0020] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("员工")
public class IBIZSample0020SearchContext extends QueryWrapperContext<IBIZSample0020> {

    @JsonProperty("n_ibizsample0020name_like")
    @JSONField(name = "n_ibizsample0020name_like")
    @ApiModelProperty("员工名称LIKE")
	private String ibizsample0020NameLIKE;
	public IBIZSample0020SearchContext setIbizsample0020NameLIKE(String ibizsample0020NameLIKE) {
        this.ibizsample0020NameLIKE = ibizsample0020NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizsample0020NameLIKE)){
            this.getSearchCond().like("ibizsample0020name", ibizsample0020NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0020id_eq")
    @JSONField(name = "n_ibizsample0020id_eq")
    @ApiModelProperty("员工标识EQ")
	private String ibizsample0020IdEQ;
	public IBIZSample0020SearchContext setIbizsample0020IdEQ(String ibizsample0020IdEQ) {
        this.ibizsample0020IdEQ = ibizsample0020IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0020IdEQ)){
            this.getSearchCond().eq("ibizsample0020id", ibizsample0020IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0019name_eq")
    @JSONField(name = "n_ibizsample0019name_eq")
    @ApiModelProperty("部门名称EQ")
	private String ibizsample0019NameEQ;
	public IBIZSample0020SearchContext setIbizsample0019NameEQ(String ibizsample0019NameEQ) {
        this.ibizsample0019NameEQ = ibizsample0019NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0019NameEQ)){
            this.getSearchCond().eq("ibizsample0019name", ibizsample0019NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0019name_like")
    @JSONField(name = "n_ibizsample0019name_like")
    @ApiModelProperty("部门名称LIKE")
	private String ibizsample0019NameLIKE;
	public IBIZSample0020SearchContext setIbizsample0019NameLIKE(String ibizsample0019NameLIKE) {
        this.ibizsample0019NameLIKE = ibizsample0019NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizsample0019NameLIKE)){
            this.getSearchCond().like("ibizsample0019name", ibizsample0019NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0019id_eq")
    @JSONField(name = "n_ibizsample0019id_eq")
    @ApiModelProperty("部门idEQ")
	private String ibizsample0019IdEQ;
	public IBIZSample0020SearchContext setIbizsample0019IdEQ(String ibizsample0019IdEQ) {
        this.ibizsample0019IdEQ = ibizsample0019IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0019IdEQ)){
            this.getSearchCond().eq("ibizsample0019id", ibizsample0019IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0020name", query)
            );
		}
	}
}