package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0018;
/**
 * 关系型数据实体[IBIZSample0018] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体18")
public class IBIZSample0018SearchContext extends QueryWrapperContext<IBIZSample0018> {

    @JsonProperty("n_ibizsample0018id_eq")
    @JSONField(name = "n_ibizsample0018id_eq")
    @ApiModelProperty("示例实体04标识EQ")
	private String ibizSample0018IdEQ;
	public IBIZSample0018SearchContext setIbizSample0018IdEQ(String ibizSample0018IdEQ) {
        this.ibizSample0018IdEQ = ibizSample0018IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0018IdEQ)){
            this.getSearchCond().eq("ibizsample0018id", ibizSample0018IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0018name_like")
    @JSONField(name = "n_ibizsample0018name_like")
    @ApiModelProperty("示例实体04名称LIKE")
	private String ibizSample0018NameLIKE;
	public IBIZSample0018SearchContext setIbizSample0018NameLIKE(String ibizSample0018NameLIKE) {
        this.ibizSample0018NameLIKE = ibizSample0018NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0018NameLIKE)){
            this.getSearchCond().like("ibizsample0018name", ibizSample0018NameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0018name", query)
            );
		}
	}
}