package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
/**
 * 关系型数据实体[IBIZSample0013] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单明细")
public class IBIZSample0013SearchContext extends QueryWrapperContext<IBIZSample0013> {

    @JsonProperty("n_ibizsample0013name_like")
    @JSONField(name = "n_ibizsample0013name_like")
    @ApiModelProperty("订单明细名称LIKE")
	private String ibizSample0013NameLIKE;
	public IBIZSample0013SearchContext setIbizSample0013NameLIKE(String ibizSample0013NameLIKE) {
        this.ibizSample0013NameLIKE = ibizSample0013NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0013NameLIKE)){
            this.getSearchCond().like("ibizsample0013name", ibizSample0013NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0013id_eq")
    @JSONField(name = "n_ibizsample0013id_eq")
    @ApiModelProperty("订单明细标识EQ")
	private String ibizSample0013IdEQ;
	public IBIZSample0013SearchContext setIbizSample0013IdEQ(String ibizSample0013IdEQ) {
        this.ibizSample0013IdEQ = ibizSample0013IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0013IdEQ)){
            this.getSearchCond().eq("ibizsample0013id", ibizSample0013IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_eq")
    @JSONField(name = "n_ibizuniproductname_eq")
    @ApiModelProperty("统一产品名称EQ")
	private String ibizuniProductNameEQ;
	public IBIZSample0013SearchContext setIbizuniProductNameEQ(String ibizuniProductNameEQ) {
        this.ibizuniProductNameEQ = ibizuniProductNameEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameEQ)){
            this.getSearchCond().eq("ibizuniproductname", ibizuniProductNameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_like")
    @JSONField(name = "n_ibizuniproductname_like")
    @ApiModelProperty("统一产品名称LIKE")
	private String ibizuniProductNameLIKE;
	public IBIZSample0013SearchContext setIbizuniProductNameLIKE(String ibizuniProductNameLIKE) {
        this.ibizuniProductNameLIKE = ibizuniProductNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameLIKE)){
            this.getSearchCond().like("ibizuniproductname", ibizuniProductNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0012name_eq")
    @JSONField(name = "n_ibizsample0012name_eq")
    @ApiModelProperty("订单名称EQ")
	private String ibizSample0012NameEQ;
	public IBIZSample0013SearchContext setIbizSample0012NameEQ(String ibizSample0012NameEQ) {
        this.ibizSample0012NameEQ = ibizSample0012NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0012NameEQ)){
            this.getSearchCond().eq("ibizsample0012name", ibizSample0012NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0012name_like")
    @JSONField(name = "n_ibizsample0012name_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizSample0012NameLIKE;
	public IBIZSample0013SearchContext setIbizSample0012NameLIKE(String ibizSample0012NameLIKE) {
        this.ibizSample0012NameLIKE = ibizSample0012NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0012NameLIKE)){
            this.getSearchCond().like("ibizsample0012name", ibizSample0012NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductid_eq")
    @JSONField(name = "n_ibizuniproductid_eq")
    @ApiModelProperty("统一产品标识EQ")
	private String ibizuniProductIdEQ;
	public IBIZSample0013SearchContext setIbizuniProductIdEQ(String ibizuniProductIdEQ) {
        this.ibizuniProductIdEQ = ibizuniProductIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductIdEQ)){
            this.getSearchCond().eq("ibizuniproductid", ibizuniProductIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0012id_eq")
    @JSONField(name = "n_ibizsample0012id_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizSample0012IdEQ;
	public IBIZSample0013SearchContext setIbizSample0012IdEQ(String ibizSample0012IdEQ) {
        this.ibizSample0012IdEQ = ibizSample0012IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0012IdEQ)){
            this.getSearchCond().eq("ibizsample0012id", ibizSample0012IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0013name", query)
            );
		}
	}
}