package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
/**
 * 关系型数据实体[IBIZSample0002] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体02")
public class IBIZSample0002SearchContext extends QueryWrapperContext<IBIZSample0002> {

    @JsonProperty("n_ibizsample0002name_like")
    @JSONField(name = "n_ibizsample0002name_like")
    @ApiModelProperty("首页图表数据源名称LIKE")
	private String ibizSample0002NameLIKE;
	public IBIZSample0002SearchContext setIbizSample0002NameLIKE(String ibizSample0002NameLIKE) {
        this.ibizSample0002NameLIKE = ibizSample0002NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0002NameLIKE)){
            this.getSearchCond().like("ibizsample0002name", ibizSample0002NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0002id_eq")
    @JSONField(name = "n_ibizsample0002id_eq")
    @ApiModelProperty("首页图表数据源标识EQ")
	private String ibizSample0002IdEQ;
	public IBIZSample0002SearchContext setIbizSample0002IdEQ(String ibizSample0002IdEQ) {
        this.ibizSample0002IdEQ = ibizSample0002IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0002IdEQ)){
            this.getSearchCond().eq("ibizsample0002id", ibizSample0002IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0002name", query)
            );
		}
	}
}