package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZOrder;
/**
 * 关系型数据实体[IBIZOrder] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZOrderSearchContext extends QueryWrapperContext<IBIZOrder> {

    @JsonProperty("n_ordertype_eq")
    @JSONField(name = "n_ordertype_eq")
    @ApiModelProperty("订单类型EQ")
	private String orderTypeEQ;
	public IBIZOrderSearchContext setOrderTypeEQ(String orderTypeEQ) {
        this.orderTypeEQ = orderTypeEQ;
        if(!ObjectUtils.isEmpty(this.orderTypeEQ)){
            this.getSearchCond().eq("ordertype", orderTypeEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizorderid_eq")
    @JSONField(name = "n_ibizorderid_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizOrderIdEQ;
	public IBIZOrderSearchContext setIbizOrderIdEQ(String ibizOrderIdEQ) {
        this.ibizOrderIdEQ = ibizOrderIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizOrderIdEQ)){
            this.getSearchCond().eq("ibizorderid", ibizOrderIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_orderstate_eq")
    @JSONField(name = "n_orderstate_eq")
    @ApiModelProperty("订单状态EQ")
	private String orderStateEQ;
	public IBIZOrderSearchContext setOrderStateEQ(String orderStateEQ) {
        this.orderStateEQ = orderStateEQ;
        if(!ObjectUtils.isEmpty(this.orderStateEQ)){
            this.getSearchCond().eq("orderstate", orderStateEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_wfstep_eq")
    @JSONField(name = "n_wfstep_eq")
    @ApiModelProperty("工作流步骤EQ")
	private String wfStepEQ;
	public IBIZOrderSearchContext setWfStepEQ(String wfStepEQ) {
        this.wfStepEQ = wfStepEQ;
        if(!ObjectUtils.isEmpty(this.wfStepEQ)){
            this.getSearchCond().eq("wfstep", wfStepEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizordername_like")
    @JSONField(name = "n_ibizordername_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizOrderNameLIKE;
	public IBIZOrderSearchContext setIbizOrderNameLIKE(String ibizOrderNameLIKE) {
        this.ibizOrderNameLIKE = ibizOrderNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizOrderNameLIKE)){
            this.getSearchCond().like("ibizordername", ibizOrderNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizordername_userlike")
    @JSONField(name = "n_ibizordername_userlike")
    @ApiModelProperty("订单名称USERLIKE")
	private String ibizOrderNameUSERLIKE;
	public IBIZOrderSearchContext setIbizOrderNameUSERLIKE(String ibizOrderNameUSERLIKE) {
        this.ibizOrderNameUSERLIKE = ibizOrderNameUSERLIKE;
        if(!ObjectUtils.isEmpty(this.ibizOrderNameUSERLIKE)){
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_gt")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_gt" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间GT")
	private Timestamp orderTimeGT;
	public IBIZOrderSearchContext setOrderTimeGT(Timestamp orderTimeGT) {
        this.orderTimeGT = orderTimeGT;
        if(!ObjectUtils.isEmpty(this.orderTimeGT)){
            this.getSearchCond().gt("ordertime", orderTimeGT);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_gtandeq")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_gtandeq" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间GTANDEQ")
	private Timestamp orderTimeGTANDEQ;
	public IBIZOrderSearchContext setOrderTimeGTANDEQ(Timestamp orderTimeGTANDEQ) {
        this.orderTimeGTANDEQ = orderTimeGTANDEQ;
        if(!ObjectUtils.isEmpty(this.orderTimeGTANDEQ)){
            this.getSearchCond().ge("ordertime", orderTimeGTANDEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_lt")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_lt" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间LT")
	private Timestamp orderTimeLT;
	public IBIZOrderSearchContext setOrderTimeLT(Timestamp orderTimeLT) {
        this.orderTimeLT = orderTimeLT;
        if(!ObjectUtils.isEmpty(this.orderTimeLT)){
            this.getSearchCond().lt("ordertime", orderTimeLT);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertime_ltandeq")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "n_ordertime_ltandeq" , format = "yyyy-MM-dd")
    @ApiModelProperty("订单时间LTANDEQ")
	private Timestamp orderTimeLTANDEQ;
	public IBIZOrderSearchContext setOrderTimeLTANDEQ(Timestamp orderTimeLTANDEQ) {
        this.orderTimeLTANDEQ = orderTimeLTANDEQ;
        if(!ObjectUtils.isEmpty(this.orderTimeLTANDEQ)){
            this.getSearchCond().le("ordertime", orderTimeLTANDEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizcustomername_eq")
    @JSONField(name = "n_ibizcustomername_eq")
    @ApiModelProperty("客户名称EQ")
	private String ibizCustomerNameEQ;
	public IBIZOrderSearchContext setIbizCustomerNameEQ(String ibizCustomerNameEQ) {
        this.ibizCustomerNameEQ = ibizCustomerNameEQ;
        if(!ObjectUtils.isEmpty(this.ibizCustomerNameEQ)){
            this.getSearchCond().eq("ibizcustomername", ibizCustomerNameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizcustomername_like")
    @JSONField(name = "n_ibizcustomername_like")
    @ApiModelProperty("客户名称LIKE")
	private String ibizCustomerNameLIKE;
	public IBIZOrderSearchContext setIbizCustomerNameLIKE(String ibizCustomerNameLIKE) {
        this.ibizCustomerNameLIKE = ibizCustomerNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizCustomerNameLIKE)){
            this.getSearchCond().like("ibizcustomername", ibizCustomerNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizcustomerid_eq")
    @JSONField(name = "n_ibizcustomerid_eq")
    @ApiModelProperty("客户标识EQ")
	private String ibizCustomerIdEQ;
	public IBIZOrderSearchContext setIbizCustomerIdEQ(String ibizCustomerIdEQ) {
        this.ibizCustomerIdEQ = ibizCustomerIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizCustomerIdEQ)){
            this.getSearchCond().eq("ibizcustomerid", ibizCustomerIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizordername", query)
            );
		}
	}
}