import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 事件调用与事件触发
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic-base.ts.ftl 生成
 * @export
 * @class EventTestUILogicBase
 */
export default class EventTestUILogicBase {

    /**
     * Creates an instance of  eventTestBase.
     * 
     * @param {*} [opts={}]
     * @memberof EventTestUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof EventTestUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '当前视图',
            codeName: 'curView',
            activeViewParam: true,
        },
        {
            name: '当前部件',
            codeName: 'curCtrl',
            activeCtrlParam: true,
            ctrlParam: true,
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
        {
            name: '消息弹窗返回值',
            codeName: 'msgReturn',
            simpleParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof EventTestUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof EventTestUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof EventTestUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EventTestUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
    console.log(`已完成执行开始节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行消息弹窗节点`);
        await this.execute_msgbox1_node(actionContext);
    }
    
    /**
     * 视图部件事件触发
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EventTestUILogicBase
     */
    protected async execute_viewctrlfireevent1_node(actionContext: UIActionContext) {
        //  事件名称
        const eventName: string = 'viewClose';
        //  事件参数
        const eventParam = 'Default';
        //  触发对象
        const fireCtrl = 'curView';
        if (!eventParam || !eventParam || !fireCtrl) {
            throw new Error(`触发对象、事件名称或者事件参数缺失`);
        }
        // 触发UI对象
        const fireUICtrl = actionContext.getParam(fireCtrl).getReal();
        // 事件参数
        const eventArgs = actionContext.getParam(eventParam).getReal();
        if (!fireUICtrl) {
            throw new Error(`获取触发对象异常`);
        }
        try {
            // 自身触发
            fireUICtrl.$emit(eventName, eventArgs);
            actionContext.bindLastReturnParam(null);
        } catch (error:any) {
            throw new Error(`视图部件事件触发未执行成功！`);
        }
    console.log(`已完成执行视图部件事件触发节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 消息弹窗
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EventTestUILogicBase
     */
    protected async execute_msgbox1_node(actionContext: UIActionContext) {
        return new Promise<void>((resolve: any) => {
            const msgBoxParam: any = actionContext.getParam('msgReturn');
            const data = msgBoxParam ? msgBoxParam.getReal() : {};
            const options = {
                type: 'QUESTION',
                title: data && data.title ? data.title : '视图是否抛出viewClose事件',
                content: data && data.message ? data.message : '',
                buttonType: 'yesno',
                showMode: '',
                showClose: false,
                mask: true,
                maskClosable: true
            };
            const subject: Subject<any> | null =  AppMessageBox.getInstance().open(options);
            if (subject) {
                const handleResponse = (result: any) => {
                    if (msgBoxParam) {
                        msgBoxParam.bind(result);
                    }
                    actionContext.bindLastReturnParam(result);
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'false')) {
                        resolve(this.execute_viewctrlinvoke1_node(actionContext));
                    }
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'true')) {
                        resolve(this.execute_viewctrlfireevent1_node(actionContext));
                    }
                }
                const subscription = subject.subscribe((result: any) => {
                    resolve(handleResponse(result));
                    subscription!.unsubscribe();
                    subject.complete();
                });
            } else {
                resolve(true);
            }
        });
    }
    
    /**
     * 视图部件调用
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EventTestUILogicBase
     */
    protected async execute_viewctrlinvoke1_node(actionContext: UIActionContext) {
        const invokeCtrl = 'curCtrl';
        const invokeMethod = 'loadDraft';
        const invokeParam = 'Default';
        if (!invokeCtrl || !invokeMethod) {
            throw new Error(`界面对象或者调用方法缺失`);
        }
        const invokeUICtrl = actionContext.getParam(invokeCtrl).getReal();
        if (invokeUICtrl[invokeMethod] && invokeUICtrl[invokeMethod] instanceof Function) {
            try {
                const result = await invokeUICtrl[invokeMethod]();
                if (invokeParam) {
                    actionContext.getParam(invokeParam).bind(result);
                }
                actionContext.bindLastReturnParam(result);
            } catch (error:any) {
                throw new Error(`${invokeCtrl}界面对象调用${invokeMethod}方法发生异常`);
            }
        } else {
            throw new Error(`${invokeCtrl}界面对象不存在${invokeMethod}方法`);
        }
    console.log(`已完成执行视图部件调用节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EventTestUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = '';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
    console.log(`已完成执行结束节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
    }
    

}