import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 实体数据集或异常
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic-base.ts.ftl 生成
 * @export
 * @class EntityDatasetUILogicBase
 */
export default class EntityDatasetUILogicBase {

    /**
     * Creates an instance of  entityDatasetBase.
     * 
     * @param {*} [opts={}]
     * @memberof EntityDatasetUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof EntityDatasetUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '消息框返回值',
            codeName: 'msgReturn',
            simpleParam: true,
        },
        {
            name: '过滤参数',
            codeName: 'filter',
            filterParam: true,
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof EntityDatasetUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof EntityDatasetUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof EntityDatasetUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EntityDatasetUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
    console.log(`已完成执行开始节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行消息弹窗节点`);
        await this.execute_msgbox1_node(actionContext);
    }
    
    /**
     * 消息弹窗
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EntityDatasetUILogicBase
     */
    protected async execute_msgbox1_node(actionContext: UIActionContext) {
        return new Promise<void>((resolve: any) => {
            const msgBoxParam: any = actionContext.getParam('msgReturn');
            const data = msgBoxParam ? msgBoxParam.getReal() : {};
            const options = {
                type: 'QUESTION',
                title: data && data.title ? data.title : '是否查询数据集',
                content: data && data.message ? data.message : '',
                buttonType: 'yesno',
                showMode: 'center',
                showClose: false,
                mask: true,
                maskClosable: true
            };
            const subject: Subject<any> | null =  AppMessageBox.getInstance().open(options);
            if (subject) {
                const handleResponse = (result: any) => {
                    if (msgBoxParam) {
                        msgBoxParam.bind(result);
                    }
                    actionContext.bindLastReturnParam(result);
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'true')) {
                        resolve(this.execute_dedataset1_node(actionContext));
                    }
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'false')) {
                        resolve(this.execute_throwexception1_node(actionContext));
                    }
                }
                const subscription = subject.subscribe((result: any) => {
                    resolve(handleResponse(result));
                    subscription!.unsubscribe();
                    subject.complete();
                });
            } else {
                resolve(true);
            }
        });
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EntityDatasetUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = '';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
    console.log(`已完成执行结束节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
    }
    
    /**
     * 抛出异常
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EntityDatasetUILogicBase
     */
    protected async execute_throwexception1_node(actionContext: UIActionContext) {
        actionContext.actionContainer.$throw('异常信息测试');
        actionContext.bindLastReturnParam(null);
    console.log(`已完成执行抛出异常节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
    }
    
    /**
     * 实体数据集
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof EntityDatasetUILogicBase
     */
    protected async execute_dedataset1_node(actionContext: UIActionContext) {
        const dstParam = actionContext.getParam('filter');
        if (!Object.is(dstParam.logicParamType, UILogicParamType.filterParam)) {
            throw new Error(`传入参数 filter 类型不正确，必须为过滤器对象`);
        }
        try {
            const service: any = await window.entityServiceRegister.getService('ibizbook');
            const res = await service['FetchDefault'](actionContext.context, dstParam.getReal() ? dstParam.getReal() : {});
            if (res && res.status === 200 && res.data) {
                // 返回值绑定逻辑参数对象
                throw new Error(`查询实体数据集失败`);
        } catch (error: any) {
            throw new Error(`${error.message ? error.message : error.data && error.data.message ? error.data.message : '查询实体数据集失败'}`);
        }
    console.log(`已完成执行实体数据集节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    

}