import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 实体行为与界面行为
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%APP_DEUILOGIC%-ui-logic-base.ts.ftl 生成
 * @export
 * @class ActiontestUILogicBase
 */
export default class ActiontestUILogicBase {

    /**
     * Creates an instance of  actiontestBase.
     * 
     * @param {*} [opts={}]
     * @memberof ActiontestUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof ActiontestUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '消息弹窗返回值',
            codeName: 'msgReturn',
            simpleParam: true,
        },
        {
            name: '查询参数',
            codeName: 'params',
            entityParam: true,
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof ActiontestUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof ActiontestUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof ActiontestUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof ActiontestUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
    console.log(`已完成执行开始节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行消息弹窗节点`);
        await this.execute_msgbox1_node(actionContext);
    }
    
    /**
     * 实体行为
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof ActiontestUILogicBase
     */
    protected async execute_deaction1_node(actionContext: UIActionContext) {
        const dstParam = actionContext.getParam('params');
        if (!Object.is(dstParam.logicParamType, UILogicParamType.entityListParam) && !Object.is(dstParam.logicParamType, UILogicParamType.entityParam)) {
            throw new Error(`实体行为操作参数只能为数据对象变量类型或者数据对象列表类型`);
        }
        const retParam = actionContext.getParam('');
        if (dstParam) {
            try {
                const service: any = await window.entityServiceRegister.getService('ibizbook');
                const getTempContext = (data: any) => {
                    const tempContext = Util.deepCopy(actionContext.context);
                    if (data) {
                        Object.assign(tempContext, data);
                    }
                    return tempContext;
                }
                // 数据对象变量类型
                if (Object.is(dstParam.logicParamType, UILogicParamType.entityParam)) {
                    const tempContext = getTempContext(dstParam.getReal());
                    const res = await service['GetDraft'](tempContext, dstParam.getReal() ? dstParam.getReal() : {});
                    if (res && res.status === 200 && res.data) {
                        if (retParam) {
                            retParam.bind(res.data);
                        }
                        actionContext.bindLastReturnParam(res.data);
                    } else {
                        throw new Error(`执行实体行为失败`);
                    }
                } else {
                    // 数据对象列表类型
                    if (dstParam.getReal() && (dstParam.getReal().length > 0)) {
                        if (dstParam.getReal().length > 20) {
                            throw new Error(`操作数据量超过20条，建议使用后台处理逻辑`);
                        }
                        let promises: any[] = [];
                        dstParam.getReal().forEach((item: any) => {
                            const tempContext = getTempContext(item);
                            promises.push(service['GetDraft'](tempContext, item ? item : {}));
                        })
                        const resArray = await Promise.all(promises);
                        if (resArray && resArray.length > 0) {
                            const resultArray: any[] = [];
                            resArray.forEach((res: any) => {
                                if (res && res.status === 200 && res.data) {
                                    resultArray.push(res.data);
                                }
                            })
                            if (retParam) {
                                retParam.bind(resultArray);
                            }
                            actionContext.bindLastReturnParam(resultArray);
                        } else {
                            throw new Error(`执行实体行为失败`);
                        }
                    } else {
                        if (retParam) {
                            retParam.bind([]);
                        }
                        actionContext.bindLastReturnParam([]);
                    }
                }
            } catch (error: any) {
                throw new Error(`${error.message ? error.message : error.data && error.data.message ? error.data.message : '执行实体行为失败'}`);
            }
        } else {
            throw new Error(`操作参数缺失！`);
        }
    console.log(`已完成执行实体行为节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof ActiontestUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = '';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
    console.log(`已完成执行结束节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
    }
    
    /**
     * 消息弹窗
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof ActiontestUILogicBase
     */
    protected async execute_msgbox1_node(actionContext: UIActionContext) {
        return new Promise<void>((resolve: any) => {
            const msgBoxParam: any = actionContext.getParam('msgReturn');
            const data = msgBoxParam ? msgBoxParam.getReal() : {};
            const options = {
                type: 'QUESTION',
                title: data && data.title ? data.title : '是否执行实体行为',
                content: data && data.message ? data.message : '',
                buttonType: 'yesno',
                showMode: '',
                showClose: false,
                mask: true,
                maskClosable: true
            };
            const subject: Subject<any> | null =  AppMessageBox.getInstance().open(options);
            if (subject) {
                const handleResponse = (result: any) => {
                    if (msgBoxParam) {
                        msgBoxParam.bind(result);
                    }
                    actionContext.bindLastReturnParam(result);
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'true')) {
                        resolve(this.execute_deaction1_node(actionContext));
                    }
                    if(Verify.testCond(this.getCondParam(actionContext, 'msgReturn', ''), 'EQ', 'false')) {
                        resolve(this.execute_deuiaction1_node(actionContext));
                    }
                }
                const subscription = subject.subscribe((result: any) => {
                    resolve(handleResponse(result));
                    subscription!.unsubscribe();
                    subject.complete();
                });
            } else {
                resolve(true);
            }
        });
    }
    
    /**
     * 界面行为
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof ActiontestUILogicBase
     */
    protected async execute_deuiaction1_node(actionContext: UIActionContext) {
        const data = actionContext.getParam('Default').getReal();
        const { context, viewparams } = actionContext;
        const additionalParam = actionContext.additionalParam;
        const uiService = await window.uiServiceRegister.getService('ibizbook');
        if (uiService && uiService['IBIZBOOK_openDocument'] && uiService['IBIZBOOK_openDocument'] instanceof Function) {
            const xData = actionContext.activeCtrlParamName ? actionContext.getParam(actionContext.activeCtrlParamName).getReal() : additionalParam && additionalParam.xData ? additionalParam.xData : {};
            const container = actionContext.activeContainerParamName ? actionContext.getParam(actionContext.activeContainerParamName).getReal() : additionalParam && additionalParam.actioncontext ? additionalParam.actioncontext : {};
            const result = await uiService['IBIZBOOK_openDocument'](
                Object.prototype.toString.call(data) === '[object Array]' ? data : [data],
                context,
                viewparams,
                additionalParam && additionalParam.$event ? additionalParam.$event : {},
                xData,
                container,
                additionalParam && additionalParam.parentDeName ? additionalParam.parentDeName : ''
            );
            if (result && result.ok && result.result) {
                actionContext.bindLastReturnParam(Array.isArray(result.result) ? result.result[0] : result.result);
            }
        }
    console.log(`已完成执行界面行为节点，操作参数数据如下:`);
    if (actionContext.paramsMap && (actionContext.paramsMap.size > 0)) {
        for (let [key, value] of actionContext.paramsMap) {
            console.log(key, Util.deepCopy(value.getReal()));
        }
    }
        console.log(`即将执行结束节点`);
        await this.execute_end1_node(actionContext);
    }
    

}