// 基于 @CONTROL/数据图表/SERVICE.ts.ftl 生成
import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import RadarModel from './radar-chart-model';


/**
 * Radar 部件服务对象
 *
 * @export
 * @class RadarService
 */
export default class RadarService extends ControlService {

    /**
     * 订单服务对象
     *
     * @type {IBIZOrderService}
     * @memberof RadarService
     */
    public appEntityService: IBIZOrderService = new IBIZOrderService();

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof RadarService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of RadarService.
     * 
     * @param {*} [opts={}]
     * @memberof RadarService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new RadarModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof RadarService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}