/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * 所有UI实体服务Map
     *
     * @protected
     * @type {*}
     * @memberof UIServiceRegister
     */
    protected allUIService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载UI实体服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof UIServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                this.allUIService.set('ibizsample0006', () => import('@/uiservice/ibizsample0006/ibizsample0006-ui-service'));
        this.allUIService.set('ibizsample0017', () => import('@/uiservice/ibizsample0017/ibizsample0017-ui-service'));
        this.allUIService.set('ibizsample0002', () => import('@/uiservice/ibizsample0002/ibizsample0002-ui-service'));
        this.allUIService.set('ibizsample0010', () => import('@/uiservice/ibizsample0010/ibizsample0010-ui-service'));
        this.allUIService.set('ibizappview', () => import('@/uiservice/ibizappview/ibizappview-ui-service'));
        this.allUIService.set('ibizcustomer_intf', () => import('@/uiservice/ibizcustomer-intf/ibizcustomer-intf-ui-service'));
        this.allUIService.set('ibizorderdetail', () => import('@/uiservice/ibizorder-detail/ibizorder-detail-ui-service'));
        this.allUIService.set('ibizsample0016', () => import('@/uiservice/ibizsample0016/ibizsample0016-ui-service'));
        this.allUIService.set('ibizorder', () => import('@/uiservice/ibizorder/ibizorder-ui-service'));
        this.allUIService.set('ibizaccount', () => import('@/uiservice/ibizaccount/ibizaccount-ui-service'));
        this.allUIService.set('ibizcustomermg', () => import('@/uiservice/ibizcustomer-mg/ibizcustomer-mg-ui-service'));
        this.allUIService.set('ibizordertype', () => import('@/uiservice/ibizorder-type/ibizorder-type-ui-service'));
        this.allUIService.set('ibizsample0014', () => import('@/uiservice/ibizsample0014/ibizsample0014-ui-service'));
        this.allUIService.set('ibizsample0001', () => import('@/uiservice/ibizsample0001/ibizsample0001-ui-service'));
        this.allUIService.set('ibizsample0008', () => import('@/uiservice/ibizsample0008/ibizsample0008-ui-service'));
        this.allUIService.set('ibizappeditor', () => import('@/uiservice/ibizappeditor/ibizappeditor-ui-service'));
        this.allUIService.set('ibizbook', () => import('@/uiservice/ibizbook/ibizbook-ui-service'));
        this.allUIService.set('ibizsample0015', () => import('@/uiservice/ibizsample0015/ibizsample0015-ui-service'));
        this.allUIService.set('ibizsample0020', () => import('@/uiservice/ibizsample0020/ibizsample0020-ui-service'));
        this.allUIService.set('ibizsample0011', () => import('@/uiservice/ibizsample0011/ibizsample0011-ui-service'));
        this.allUIService.set('ibizcpu', () => import('@/uiservice/ibizcpu/ibizcpu-ui-service'));
        this.allUIService.set('ibizsample0012', () => import('@/uiservice/ibizsample0012/ibizsample0012-ui-service'));
        this.allUIService.set('ibizsample', () => import('@/uiservice/ibizsample/ibizsample-ui-service'));
        this.allUIService.set('ibizsupplier', () => import('@/uiservice/ibizsupplier/ibizsupplier-ui-service'));
        this.allUIService.set('ibizsample0004', () => import('@/uiservice/ibizsample0004/ibizsample0004-ui-service'));
        this.allUIService.set('ibizsoftwaresuit', () => import('@/uiservice/ibizsoftware-suit/ibizsoftware-suit-ui-service'));
        this.allUIService.set('ibizhardware', () => import('@/uiservice/ibizhardware/ibizhardware-ui-service'));
        this.allUIService.set('ibizsample0007', () => import('@/uiservice/ibizsample0007/ibizsample0007-ui-service'));
        this.allUIService.set('ibizsample0018', () => import('@/uiservice/ibizsample0018/ibizsample0018-ui-service'));
        this.allUIService.set('ibizsample0019', () => import('@/uiservice/ibizsample0019/ibizsample0019-ui-service'));
        this.allUIService.set('ibizstorage', () => import('@/uiservice/ibizstorage/ibizstorage-ui-service'));
        this.allUIService.set('ibizsample0003', () => import('@/uiservice/ibizsample0003/ibizsample0003-ui-service'));
        this.allUIService.set('ibizsample0009', () => import('@/uiservice/ibizsample0009/ibizsample0009-ui-service'));
        this.allUIService.set('ibizsample0013', () => import('@/uiservice/ibizsample0013/ibizsample0013-ui-service'));
        this.allUIService.set('ibizappctrl', () => import('@/uiservice/ibizappctrl/ibizappctrl-ui-service'));
        this.allUIService.set('ibizcustomer', () => import('@/uiservice/ibizcustomer/ibizcustomer-ui-service'));
        this.allUIService.set('ibizcustom', () => import('@/uiservice/ibizcustom/ibizcustom-ui-service'));
        this.allUIService.set('ibizsample0005', () => import('@/uiservice/ibizsample0005/ibizsample0005-ui-service'));
        this.allUIService.set('ibizuniproduct', () => import('@/uiservice/ibizuniproduct/ibizuniproduct-ui-service'));
    }

    /**
     * 加载服务实体
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allUIService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const uiServiceRegister: UIServiceRegister = new UIServiceRegister();