import IBIZUNIProductService from '@/service/ibizuniproduct/ibizuniproduct-service';
import { Verify } from '@/utils/verify/verify';


/**
 * 通过商品ID获取单价及单位
 * 基于 APP/src/service/%DE_PKGPATH%/%APP_DELOGIC%-logic-base.ts.ftl 生成
 * @export
 * @class GetUnitAndPriceLogicBase
 */
export default class GetUnitAndPriceLogicBase {

    /**
     * 名称
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private name:string ="GetUnitAndPrice";

    /**
     * 唯一标识
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private id:string = "ded186a4036f371f623ecdb8b799f94c";

    /**
     * 默认参数名称
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private defaultParamName:string = "Default";

    /**
     * 参数集合
     * 
     * @memberof  GetUnitAndPriceLogicBase
     */
    private paramsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  GetUnitAndPriceLogicBase.
     * 
     * @param {*} [opts={}]
     * @memberof  GetUnitAndPriceLogicBase
     */
    constructor(opts: any = {}) {
        this.initParams(opts);
    }

    /**
     * 初始化参数集合
     * 
     * @param {*} [opts={}]
     * @memberof  GetUnitAndPriceLogicBase
     */
    public initParams(opts:any){
        this.paramsMap.set('Product',{});
        this.paramsMap.set('Default',opts);
    }


    /**
     * 计算0节点结果
     * 
     * @param params 传入参数
     */
    public compute0Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算1节点结果
     * 
     * @param params 传入参数
     */
    public compute1Cond(params:any):boolean{
        return true;
    }

    /**
     * 计算2节点结果
     * 
     * @param params 传入参数
     */
    public compute2Cond(params:any):boolean{
        return true;
    }

    /**
     * 执行逻辑
     * 
     * @param context 应用上下文
     * @param params 传入参数
     */
    public onExecute(context:any,params:any,isloading:boolean){
        return this.executeBegin(context,params,isloading);
    }


    /**
    * 开始
    * 
    * @param params 传入参数
    */
    private async executeBegin(context:any,params:any,isloading:boolean){
        //开始节点
        if(this.compute0Cond(params)){
            return this.executePrepareparam1(context,params,isloading);   
        }
    }

    /**
    * 填充单位和单价
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePrepareparam2(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Default').context?this.paramsMap.get('Default').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    let tempSrcParam0Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    Object.assign(tempDstParam0Data,{unitprice:tempSrcParam0Data['unitprice']});
    this.paramsMap.set('Default',{data:tempDstParam0Data,context:tempDstParam0Context});
    let tempDstParam1Context:any = this.paramsMap.get('Default').context?this.paramsMap.get('Default').context:{};
    let tempDstParam1Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    let tempSrcParam1Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    Object.assign(tempDstParam1Data,{unit:tempSrcParam1Data['unit']});
    this.paramsMap.set('Default',{data:tempDstParam1Data,context:tempDstParam1Context});
        return this.paramsMap.get(this.defaultParamName).data;
    }

    /**
    * 获取商品信息
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executeDeaction1(context:any,params:any,isloading:boolean){
        // 行为处理节点
        let result: any;
        let actionParam:any = this.paramsMap.get('Product');
        const targetService:IBIZUNIProductService = new IBIZUNIProductService();
        if (targetService['Get'] && targetService['Get'] instanceof Function) {
            result = await targetService['Get'](actionParam.context,actionParam.data, false);
        }
        if(result && result.status == 200){
            Object.assign(actionParam.data,result.data);
        if(this.compute1Cond(params)){
            return this.executePrepareparam2(context,params,isloading);   
        }
        }
    }

    /**
    * 获取商品ID
    * 
    * @param context 应用上下文
    * @param params 传入参数
    */
    private async executePrepareparam1(context:any,params:any,isloading:boolean){
        // 准备参数节点
    let tempDstParam0Context:any = this.paramsMap.get('Product').context?this.paramsMap.get('Product').context:{};
    let tempDstParam0Data:any = this.paramsMap.get('Product').data?this.paramsMap.get('Product').data:{};
    let tempSrcParam0Data:any = this.paramsMap.get('Default').data?this.paramsMap.get('Default').data:{};
    Object.assign(tempDstParam0Context,{ibizuniproduct:tempSrcParam0Data['ibizuniproductid']});
    Object.assign(tempDstParam0Data,{ibizuniproductid:tempSrcParam0Data['ibizuniproductid']});
    this.paramsMap.set('Product',{data:tempDstParam0Data,context:tempDstParam0Context});
        if(this.compute2Cond(params)){
            return this.executeDeaction1(context,params,isloading);   
        }
    }


}