package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0021;
import cn.ibizlab.core.sample.service.IIBIZSample0021Service;
import cn.ibizlab.core.sample.filter.IBIZSample0021SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("DemoAPI-ibizsample0021")
@RequestMapping("")
public class IBIZSample0021Resource {

    @Autowired
    public IIBIZSample0021Service ibizsample0021Service;

    @Autowired
    @Lazy
    public IBIZSample0021Mapping ibizsample0021Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0021Mapping.toDomain(#ibizsample0021dto),'DemoSys-IBIZSample0021-Create')")
    @ApiOperation(value = "新建订单", tags = {"订单" },  notes = "新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0021s")
    public ResponseEntity<IBIZSample0021DTO> create(@Validated @RequestBody IBIZSample0021DTO ibizsample0021dto) {
        IBIZSample0021 domain = ibizsample0021Mapping.toDomain(ibizsample0021dto);
		ibizsample0021Service.create(domain);
        IBIZSample0021DTO dto = ibizsample0021Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Mapping.toDomain(#ibizsample0021dtos),'DemoSys-IBIZSample0021-Create')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0021s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0021DTO> ibizsample0021dtos) {
        ibizsample0021Service.createBatch(ibizsample0021Mapping.toDomain(ibizsample0021dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0021Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0021-Get')")
    @ApiOperation(value = "获取订单", tags = {"订单" },  notes = "获取订单")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0021s/{ibizsample0021_id}")
    public ResponseEntity<IBIZSample0021DTO> get(@PathVariable("ibizsample0021_id") String ibizsample0021_id) {
        IBIZSample0021 domain = ibizsample0021Service.get(ibizsample0021_id);
        IBIZSample0021DTO dto = ibizsample0021Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Service.get(#ibizsample0021_id),'DemoSys-IBIZSample0021-Remove')")
    @ApiOperation(value = "删除订单", tags = {"订单" },  notes = "删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0021s/{ibizsample0021_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0021_id") String ibizsample0021_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0021Service.remove(ibizsample0021_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Service.getIbizsample0021ByIds(#ids),'DemoSys-IBIZSample0021-Remove')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0021s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0021Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0021" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0021Service.get(#ibizsample0021_id),'DemoSys-IBIZSample0021-Update')")
    @ApiOperation(value = "更新订单", tags = {"订单" },  notes = "更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0021s/{ibizsample0021_id}")
    public ResponseEntity<IBIZSample0021DTO> update(@PathVariable("ibizsample0021_id") String ibizsample0021_id, @RequestBody IBIZSample0021DTO ibizsample0021dto) {
		IBIZSample0021 domain  = ibizsample0021Mapping.toDomain(ibizsample0021dto);
        domain .setIbizsample0021id(ibizsample0021_id);
		ibizsample0021Service.update(domain );
		IBIZSample0021DTO dto = ibizsample0021Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Service.getIbizsample0021ByEntities(this.ibizsample0021Mapping.toDomain(#ibizsample0021dtos)),'DemoSys-IBIZSample0021-Update')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0021s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0021DTO> ibizsample0021dtos) {
        ibizsample0021Service.updateBatch(ibizsample0021Mapping.toDomain(ibizsample0021dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查订单", tags = {"订单" },  notes = "检查订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0021s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0021DTO ibizsample0021dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0021Service.checkKey(ibizsample0021Mapping.toDomain(ibizsample0021dto)));
    }

    @ApiOperation(value = "获取订单草稿", tags = {"订单" },  notes = "获取订单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0021s/getdraft")
    public ResponseEntity<IBIZSample0021DTO> getDraft(IBIZSample0021DTO dto) {
        IBIZSample0021 domain = ibizsample0021Mapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0021Mapping.toDto(ibizsample0021Service.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Mapping.toDomain(#ibizsample0021dto),'DemoSys-IBIZSample0021-Save')")
    @ApiOperation(value = "保存订单", tags = {"订单" },  notes = "保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0021s/save")
    public ResponseEntity<IBIZSample0021DTO> save(@RequestBody IBIZSample0021DTO ibizsample0021dto) {
        IBIZSample0021 domain = ibizsample0021Mapping.toDomain(ibizsample0021dto);
        ibizsample0021Service.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0021Mapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0021Mapping.toDomain(#ibizsample0021dtos),'DemoSys-IBIZSample0021-Save')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0021s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0021DTO> ibizsample0021dtos) {
        ibizsample0021Service.saveBatch(ibizsample0021Mapping.toDomain(ibizsample0021dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0021-Get')")
	@ApiOperation(value = "获取数据集", tags = {"订单" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0021s/fetchdefault")
	public ResponseEntity<List<IBIZSample0021DTO>> fetchDefault(IBIZSample0021SearchContext context) {
        Page<IBIZSample0021> domains = ibizsample0021Service.searchDefault(context) ;
        List<IBIZSample0021DTO> list = ibizsample0021Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0021-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0021-Get')")
	@ApiOperation(value = "查询数据集", tags = {"订单" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0021s/searchdefault")
	public ResponseEntity<Page<IBIZSample0021DTO>> searchDefault(@RequestBody IBIZSample0021SearchContext context) {
        Page<IBIZSample0021> domains = ibizsample0021Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0021Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

