package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAPPCTRLDTO]
 */
@Data
@ApiModel("应用部件")
public class IBIZAPPCTRLDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZAPPCTRLNAME]
     *
     */
    @JSONField(name = "ibizappctrlname")
    @JsonProperty("ibizappctrlname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("应用部件名称")
    private String ibizappctrlname;

    /**
     * 属性 [IBIZAPPCTRLID]
     *
     */
    @JSONField(name = "ibizappctrlid")
    @JsonProperty("ibizappctrlid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("应用部件标识")
    private String ibizappctrlid;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [IBIZAPPCTRLTYPE]
     *
     */
    @JSONField(name = "ibizappctrltype")
    @JsonProperty("ibizappctrltype")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("应用部件类型")
    private String ibizappctrltype;

    /**
     * 属性 [CTRLDESCRIPTION]
     *
     */
    @JSONField(name = "ctrldescription")
    @JsonProperty("ctrldescription")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("部件描述")
    private String ctrldescription;

    /**
     * 属性 [DOCUMENTADDRESS]
     *
     */
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("文档地址")
    private String documentaddress;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    @ApiModelProperty("数量")
    private Integer amount;


    /**
     * 设置 [IBIZAPPCTRLNAME]
     */
    public void setIbizappctrlname(String  ibizappctrlname){
        this.ibizappctrlname = ibizappctrlname ;
        this.modify("ibizappctrlname",ibizappctrlname);
    }

    /**
     * 设置 [IBIZAPPCTRLTYPE]
     */
    public void setIbizappctrltype(String  ibizappctrltype){
        this.ibizappctrltype = ibizappctrltype ;
        this.modify("ibizappctrltype",ibizappctrltype);
    }

    /**
     * 设置 [CTRLDESCRIPTION]
     */
    public void setCtrldescription(String  ctrldescription){
        this.ctrldescription = ctrldescription ;
        this.modify("ctrldescription",ctrldescription);
    }

    /**
     * 设置 [DOCUMENTADDRESS]
     */
    public void setDocumentaddress(String  documentaddress){
        this.documentaddress = documentaddress ;
        this.modify("documentaddress",documentaddress);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Integer  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }


}


