package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZAPPEXTENDEDITORDTO]
 */
@Data
public class IBIZAPPEXTENDEDITORDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [IBIZAPPEXTENDEDITORNAME]
     *
     */
    @JSONField(name = "ibizappextendeditorname")
    @JsonProperty("ibizappextendeditorname")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizappextendeditorname;

    /**
     * 属性 [IBIZAPPEXTENDEDITORID]
     *
     */
    @JSONField(name = "ibizappextendeditorid")
    @JsonProperty("ibizappextendeditorid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizappextendeditorid;

    /**
     * 属性 [EXTENSIONFLAG]
     *
     */
    @JSONField(name = "extensionflag")
    @JsonProperty("extensionflag")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String extensionflag;

    /**
     * 属性 [DOCUMENTADDRESS]
     *
     */
    @JSONField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String documentaddress;

    /**
     * 属性 [EXTENDEDITORDESCRIPTION]
     *
     */
    @JSONField(name = "extendeditordescription")
    @JsonProperty("extendeditordescription")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String extendeditordescription;

    /**
     * 属性 [AMOUNT]
     *
     */
    @JSONField(name = "amount")
    @JsonProperty("amount")
    private Integer amount;

    /**
     * 属性 [EXTENDEDITORTYPE]
     *
     */
    @JSONField(name = "extendeditortype")
    @JsonProperty("extendeditortype")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String extendeditortype;


    /**
     * 设置 [IBIZAPPEXTENDEDITORNAME]
     */
    public void setIbizappextendeditorname(String  ibizappextendeditorname){
        this.ibizappextendeditorname = ibizappextendeditorname ;
        this.modify("ibizappextendeditorname",ibizappextendeditorname);
    }

    /**
     * 设置 [EXTENSIONFLAG]
     */
    public void setExtensionflag(String  extensionflag){
        this.extensionflag = extensionflag ;
        this.modify("extensionflag",extensionflag);
    }

    /**
     * 设置 [DOCUMENTADDRESS]
     */
    public void setDocumentaddress(String  documentaddress){
        this.documentaddress = documentaddress ;
        this.modify("documentaddress",documentaddress);
    }

    /**
     * 设置 [EXTENDEDITORDESCRIPTION]
     */
    public void setExtendeditordescription(String  extendeditordescription){
        this.extendeditordescription = extendeditordescription ;
        this.modify("extendeditordescription",extendeditordescription);
    }

    /**
     * 设置 [AMOUNT]
     */
    public void setAmount(Integer  amount){
        this.amount = amount ;
        this.modify("amount",amount);
    }

    /**
     * 设置 [EXTENDEDITORTYPE]
     */
    public void setExtendeditortype(String  extendeditortype){
        this.extendeditortype = extendeditortype ;
        this.modify("extendeditortype",extendeditortype);
    }


}


