package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0001;
import cn.ibizlab.core.sample.filter.IBIZSample0001SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0001Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0001Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
import cn.ibizlab.core.sample.service.IBIZSample0002Service;


/**
 * 实体[示例实体01] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0001Service")
public class IBIZSample0001ServiceBase extends ServiceImpl<IBIZSample0001Mapper,IBIZSample0001> implements IBIZSample0001Service {

    @Autowired
    @Lazy
    protected IBIZSample0002Service ibizSample0002Service;
   

    protected int batchSize = 500;

    public IBIZSample0001 get(IBIZSample0001 et) {
        IBIZSample0001 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,示例实体01:"+et.getIbizSample0001Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0001> getByEntities(List<IBIZSample0001> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0001 et) {
        if(!ObjectUtils.isEmpty(et.getIbizSample0002Id())) {
            IBIZSample0002 ibizSample0002 = et.getSample0002Sample00011N();
            if(!ObjectUtils.isEmpty(ibizSample0002)) {
                et.setIbizSample0002Name(ibizSample0002.getIbizSample0002Name());   
            }
        }    
    }

    public IBIZSample0001 getDraft(IBIZSample0001 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0001 et) {
        fillParentData(et);
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0001Id())) && this.count(Wrappers.<IBIZSample0001>query().eq("ibizsample0001id", et.getIbizSample0001Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0001 et) {
        fillParentData(et);
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0001> list) {
        list.forEach(et->fillParentData(et));
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0001 et) {
        fillParentData(et);
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0001id", et.getIbizSample0001Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0001> list) {
        list.forEach(et->fillParentData(et));
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0001 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0001> list) {
        List<IBIZSample0001> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0001Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0001> _create=new ArrayList<>();
        List<IBIZSample0001> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0001Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0001 et) {
        String key = et.getIbizSample0001Id();

        if(!remove(new QueryWrapper<IBIZSample0001>()
                .eq("ibizsample0001id", et.getIbizSample0001Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0001> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0001> searchDefault(IBIZSample0001SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0001> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0001>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0001> listDefault(IBIZSample0001SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0001> selectByIbizSample0002Id(String ibizSample0002Id) {
        return baseMapper.selectByIbizSample0002Id(ibizSample0002Id);
    }

    public boolean removeByIbizSample0002Id(String ibizSample0002Id) {
        return this.remove(new QueryWrapper<IBIZSample0001>().eq("ibizsample0002id",ibizSample0002Id));
    }

    public boolean resetByIbizSample0002Id(String ibizSample0002Id) {
        return this.update(new UpdateWrapper<IBIZSample0001>().set("ibizsample0002id",null).eq("ibizsample0002id",ibizSample0002Id));
    }

    public boolean saveBySample0002Sample00011N(IBIZSample0002 ibizSample0002,List<IBIZSample0001> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0001> _update=new ArrayList<IBIZSample0001>();
        List<IBIZSample0001> _create=new ArrayList<IBIZSample0001>();
        for(IBIZSample0001 before:selectByIbizSample0002Id(ibizSample0002.getIbizSample0002Id())){
            delIds.add(before.getIbizSample0001Id());
        }
        for(IBIZSample0001 sub:list) {
            sub.setIbizSample0002Id(ibizSample0002.getIbizSample0002Id());
            sub.setSample0002Sample00011N(ibizSample0002);
            if(ObjectUtils.isEmpty(sub.getIbizSample0001Id()))
                sub.setIbizSample0001Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0001Id())) {
                delIds.remove(sub.getIbizSample0001Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}