package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZAccount;
import cn.ibizlab.core.sample.filter.IBIZAccountSearchContext;
import cn.ibizlab.core.sample.service.IBIZAccountService;
import cn.ibizlab.core.sample.mapper.IBIZAccountMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZCustomer;
import cn.ibizlab.core.sample.service.IBIZCustomerService;


/**
 * 实体[账户] 服务对象接口实现
 */
@Slf4j
@Service("IBIZAccountService")
public class IBIZAccountServiceBase extends ServiceImpl<IBIZAccountMapper,IBIZAccount> implements IBIZAccountService {

    @Autowired
    @Lazy
    protected IBIZCustomerService ibizCustomerService;
   

    protected int batchSize = 500;

    public IBIZAccount get(IBIZAccount et) {
        IBIZAccount rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,账户:"+et.getIbizAccountId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZAccount> getByEntities(List<IBIZAccount> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZAccount et) {
    }

    public IBIZAccount getDraft(IBIZAccount et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZAccount et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizAccountId())) && this.count(Wrappers.<IBIZAccount>query().eq("ibizaccountid", et.getIbizAccountId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZAccount et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZAccount> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZAccount et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizaccountid", et.getIbizAccountId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZAccount> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZAccount et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZAccount> list) {
        List<IBIZAccount> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizAccountId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZAccount> _create=new ArrayList<>();
        List<IBIZAccount> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizAccountId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZAccount et) {
        String key = et.getIbizAccountId();

        if(!remove(new QueryWrapper<IBIZAccount>()
                .eq("ibizaccountid", et.getIbizAccountId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZAccount> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZAccount> searchDefault(IBIZAccountSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZAccount> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZAccount>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZAccount> listDefault(IBIZAccountSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZAccount> selectByIbizAccountId(String ibizAccountId) {
        return baseMapper.selectByIbizAccountId(ibizAccountId);
    }

    public boolean removeByIbizAccountId(String ibizAccountId) {
        return this.remove(new QueryWrapper<IBIZAccount>().eq("ibizaccountid",ibizAccountId));
    }

    public boolean resetByIbizAccountId(String ibizAccountId) {
        return this.update(new UpdateWrapper<IBIZAccount>().set("ibizaccountid",null).eq("ibizaccountid",ibizAccountId));
    }

    public boolean saveByIbizcustomer(IBIZCustomer ibizCustomer,List<IBIZAccount> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZAccount> _update=new ArrayList<IBIZAccount>();
        List<IBIZAccount> _create=new ArrayList<IBIZAccount>();
        for(IBIZAccount before:selectByIbizAccountId(ibizCustomer.getIbizCustomerId())){
            delIds.add(before.getIbizAccountId());
        }
        for(IBIZAccount sub:list) {
            sub.setIbizAccountId(ibizCustomer.getIbizCustomerId());
            sub.setIbizcustomer(ibizCustomer);
            if(ObjectUtils.isEmpty(sub.getIbizAccountId()))
                sub.setIbizAccountId((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizAccountId())) {
                delIds.remove(sub.getIbizAccountId());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}