package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;
import cn.ibizlab.core.sample.service.IBIZCustomer_INTFService;
import cn.ibizlab.core.sample.mapper.IBIZCustomer_INTFMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[客户] 服务对象接口实现
 */
@Slf4j
@Service("IBIZCustomer_INTFService")
public class IBIZCustomer_INTFServiceBase extends ServiceImpl<IBIZCustomer_INTFMapper,IBIZCustomer_INTF> implements IBIZCustomer_INTFService {


    protected int batchSize = 500;

    public IBIZCustomer_INTF get(IBIZCustomer_INTF et) {
        IBIZCustomer_INTF rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,客户:"+et.getIbizCustomerId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZCustomer_INTF> getByEntities(List<IBIZCustomer_INTF> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZCustomer_INTF getDraft(IBIZCustomer_INTF et) {
        return et;
    }

    public Integer checkKey(IBIZCustomer_INTF et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizCustomerId())) && this.count(Wrappers.<IBIZCustomer_INTF>query().eq("ibizcustomerid", et.getIbizCustomerId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZCustomer_INTF et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZCustomer_INTF> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZCustomer_INTF et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizcustomerid", et.getIbizCustomerId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZCustomer_INTF> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZCustomer_INTF et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZCustomer_INTF> list) {
        List<IBIZCustomer_INTF> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizCustomerId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZCustomer_INTF> _create=new ArrayList<>();
        List<IBIZCustomer_INTF> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizCustomerId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZCustomer_INTF et) {
        String key = et.getIbizCustomerId();

        if(!remove(new QueryWrapper<IBIZCustomer_INTF>()
                .eq("ibizcustomerid", et.getIbizCustomerId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZCustomer_INTF> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    @Transactional
    public IBIZCustomer_INTF xxx(IBIZCustomer_INTF dto) {
        return dto;
    }

    public Page<IBIZCustomer_INTF> searchCurCustomer(IBIZCustomer_INTFSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustomer_INTF> pages=baseMapper.searchCurCustomer(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustomer_INTF>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZCustomer_INTF> listCurCustomer(IBIZCustomer_INTFSearchContext context) {
        return baseMapper.listCurCustomer(context,context.getSelectCond());
    }

    public Page<IBIZCustomer_INTF> searchDefault(IBIZCustomer_INTFSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZCustomer_INTF> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZCustomer_INTF>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZCustomer_INTF> listDefault(IBIZCustomer_INTFSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}