package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZCustom;
import cn.ibizlab.core.sample.filter.IBIZCustomSearchContext;

public interface IBIZCustomService extends IService<IBIZCustom> {

    default IBIZCustomService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZCustom get(IBIZCustom et);
    default IBIZCustom get(String key) {
        IBIZCustom et = new IBIZCustom();
        et.setIbizCustomId(key);
        return getSelf().get(et);
    }
    default List<IBIZCustom> getByIds(Collection<String> ids) {
        List<IBIZCustom> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustom et = new IBIZCustom();
            et.setIbizCustomId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZCustom> getByEntities(List<IBIZCustom> entities);

    IBIZCustom getDraft(IBIZCustom et);

    Integer checkKey(IBIZCustom et);

    boolean create(IBIZCustom et);
    boolean createBatch(List<IBIZCustom> list);

    boolean update(IBIZCustom et);
    boolean updateBatch(List<IBIZCustom> list);

    boolean save(IBIZCustom et);
    boolean saveBatch(List<IBIZCustom> list);

    default boolean remove(String key) {
        IBIZCustom et = new IBIZCustom();
        et.setIbizCustomId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZCustom et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZCustom> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustom et = new IBIZCustom();
            et.setIbizCustomId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZCustom> entities);

    Page<IBIZCustom> searchDefault(IBIZCustomSearchContext context);
    List<IBIZCustom> listDefault(IBIZCustomSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}