package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZTASK;
/**
 * 关系型数据实体[IBIZTASK] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("任务")
public class IBIZTASKSearchContext extends QueryWrapperContext<IBIZTASK> {

    @JsonProperty("n_ibiztaskid_eq")
    @JSONField(name = "n_ibiztaskid_eq")
    @ApiModelProperty("任务标识EQ")
	private String ibiztaskidEQ;
	public IBIZTASKSearchContext setIbiztaskidEQ(String ibiztaskidEQ) {
        this.ibiztaskidEQ = ibiztaskidEQ;
        if(!ObjectUtils.isEmpty(this.ibiztaskidEQ)){
            this.getSearchCond().eq("ibiztaskid", ibiztaskidEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibiztaskname_like")
    @JSONField(name = "n_ibiztaskname_like")
    @ApiModelProperty("任务名称LIKE")
	private String ibiztaskNameLIKE;
	public IBIZTASKSearchContext setIbiztaskNameLIKE(String ibiztaskNameLIKE) {
        this.ibiztaskNameLIKE = ibiztaskNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibiztaskNameLIKE)){
            this.getSearchCond().like("ibiztaskname", ibiztaskNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibiztaskname", query)
            );
		}
	}
}