package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
/**
 * 关系型数据实体[IBIZSample0012] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZSample0012SearchContext extends QueryWrapperContext<IBIZSample0012> {

    @JsonProperty("n_ibizsample0012id_eq")
    @JSONField(name = "n_ibizsample0012id_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizSample0012IdEQ;
	public IBIZSample0012SearchContext setIbizSample0012IdEQ(String ibizSample0012IdEQ) {
        this.ibizSample0012IdEQ = ibizSample0012IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0012IdEQ)){
            this.getSearchCond().eq("ibizsample0012id", ibizSample0012IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0012name_like")
    @JSONField(name = "n_ibizsample0012name_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizSample0012NameLIKE;
	public IBIZSample0012SearchContext setIbizSample0012NameLIKE(String ibizSample0012NameLIKE) {
        this.ibizSample0012NameLIKE = ibizSample0012NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0012NameLIKE)){
            this.getSearchCond().like("ibizsample0012name", ibizSample0012NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ordertype_eq")
    @JSONField(name = "n_ordertype_eq")
    @ApiModelProperty("订单类型EQ")
	private String orderTypeEQ;
	public IBIZSample0012SearchContext setOrderTypeEQ(String orderTypeEQ) {
        this.orderTypeEQ = orderTypeEQ;
        if(!ObjectUtils.isEmpty(this.orderTypeEQ)){
            this.getSearchCond().eq("ordertype", orderTypeEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0012name", query)
            );
		}
	}
}