package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0013;
import cn.ibizlab.core.sample.filter.IBIZSample0013SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0013Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0013Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.service.IBIZSample0012Service;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.service.IBIZUNIProductService;


/**
 * 实体[订单明细] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0013Service")
public class IBIZSample0013ServiceBase extends ServiceImpl<IBIZSample0013Mapper,IBIZSample0013> implements IBIZSample0013Service {

    @Autowired
    @Lazy
    protected IBIZSample0012Service ibizSample0012Service;
   
    @Autowired
    @Lazy
    protected IBIZUNIProductService ibizuniProductService;
   

    protected int batchSize = 500;

    public IBIZSample0013 get(IBIZSample0013 et) {
        IBIZSample0013 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,订单明细:"+et.getIbizSample0013Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0013> getByEntities(List<IBIZSample0013> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0013 et) {
        if(!ObjectUtils.isEmpty(et.getIbizSample0012Id())) {
            IBIZSample0012 ibizSample0012 = et.getIbizsample0012();
            if(!ObjectUtils.isEmpty(ibizSample0012)) {
                et.setIbizSample0012Name(ibizSample0012.getIbizSample0012Name());   
            }
        }    
        if(!ObjectUtils.isEmpty(et.getIbizuniProductId())) {
            IBIZUNIProduct ibizuniProduct = et.getIbizuniproduct();
            if(!ObjectUtils.isEmpty(ibizuniProduct)) {
                et.setUnit(ibizuniProduct.getUnit());   
                et.setIbizuniProductName(ibizuniProduct.getIbizuniProductName());   
                et.setUnitPrice(ibizuniProduct.getUnitPrice());   
            }
        }    
    }

    public IBIZSample0013 getDraft(IBIZSample0013 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0013 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0013Id())) && this.count(Wrappers.<IBIZSample0013>query().eq("ibizsample0013id", et.getIbizSample0013Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0013 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0013> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0013 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0013id", et.getIbizSample0013Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0013> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0013 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0013> list) {
        List<IBIZSample0013> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0013Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0013> _create=new ArrayList<>();
        List<IBIZSample0013> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0013Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0013 et) {
        String key = et.getIbizSample0013Id();

        if(!remove(new QueryWrapper<IBIZSample0013>()
                .eq("ibizsample0013id", et.getIbizSample0013Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0013> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0013> searchDefault(IBIZSample0013SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0013> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0013>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0013> listDefault(IBIZSample0013SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0013> selectByIbizSample0012Id(String ibizSample0012Id) {
        return baseMapper.selectByIbizSample0012Id(ibizSample0012Id);
    }

    public boolean removeByIbizSample0012Id(String ibizSample0012Id) {
        return this.remove(new QueryWrapper<IBIZSample0013>().eq("ibizsample0012id",ibizSample0012Id));
    }

    public boolean resetByIbizSample0012Id(String ibizSample0012Id) {
        return this.update(new UpdateWrapper<IBIZSample0013>().set("ibizsample0012id",null).eq("ibizsample0012id",ibizSample0012Id));
    }

    public boolean saveByIbizsample0012(IBIZSample0012 ibizSample0012,List<IBIZSample0013> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0013> _update=new ArrayList<IBIZSample0013>();
        List<IBIZSample0013> _create=new ArrayList<IBIZSample0013>();
        for(IBIZSample0013 before:selectByIbizSample0012Id(ibizSample0012.getIbizSample0012Id())){
            delIds.add(before.getIbizSample0013Id());
        }
        for(IBIZSample0013 sub:list) {
            sub.setIbizSample0012Id(ibizSample0012.getIbizSample0012Id());
            sub.setIbizsample0012(ibizSample0012);
            if(ObjectUtils.isEmpty(sub.getIbizSample0013Id()))
                sub.setIbizSample0013Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0013Id())) {
                delIds.remove(sub.getIbizSample0013Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }

    public List<IBIZSample0013> selectByIbizuniProductId(String ibizuniProductId) {
        return baseMapper.selectByIbizuniProductId(ibizuniProductId);
    }

    public boolean removeByIbizuniProductId(String ibizuniProductId) {
        return this.remove(new QueryWrapper<IBIZSample0013>().eq("ibizuniproductid",ibizuniProductId));
    }

    public boolean resetByIbizuniProductId(String ibizuniProductId) {
        return this.update(new UpdateWrapper<IBIZSample0013>().set("ibizuniproductid",null).eq("ibizuniproductid",ibizuniProductId));
    }

    public boolean saveByIbizuniproduct(IBIZUNIProduct ibizuniProduct,List<IBIZSample0013> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0013> _update=new ArrayList<IBIZSample0013>();
        List<IBIZSample0013> _create=new ArrayList<IBIZSample0013>();
        for(IBIZSample0013 before:selectByIbizuniProductId(ibizuniProduct.getIbizuniProductId())){
            delIds.add(before.getIbizSample0013Id());
        }
        for(IBIZSample0013 sub:list) {
            sub.setIbizuniProductId(ibizuniProduct.getIbizuniProductId());
            sub.setIbizuniproduct(ibizuniProduct);
            if(ObjectUtils.isEmpty(sub.getIbizSample0013Id()))
                sub.setIbizSample0013Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0013Id())) {
                delIds.remove(sub.getIbizSample0013Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }




    @Override
    public List<JSONObject> select(String sql, Map param){
        return this.baseMapper.selectBySQL(sql,param);
    }

    @Override
    @Transactional
    public boolean execute(String sql , Map param){
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        if (sql.toLowerCase().trim().startsWith("insert")) {
            return this.baseMapper.insertBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("update")) {
            return this.baseMapper.updateBySQL(sql,param);
        }
        if (sql.toLowerCase().trim().startsWith("delete")) {
            return this.baseMapper.deleteBySQL(sql,param);
        }
        log.warn("暂未支持的SQL语法");
        return true;
    }

}