package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0002DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体02")
public class IBIZSample0002DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 实体
     */
    @JsonProperty("de")
    @JSONField(name = "de")
    @ApiModelProperty("实体")
    private String de;

    /**
     * 实体数据量
     */
    @JsonProperty("denum")
    @JSONField(name = "denum")
    @ApiModelProperty("实体数据量")
    private Integer deNum;

    /**
     * 首页图表数据源标识
     */
    @JsonProperty("ibizsample0002id")
    @JSONField(name = "ibizsample0002id")
    @ApiModelProperty("首页图表数据源标识")
    private String ibizSample0002Id;

    /**
     * 首页图表数据源名称
     */
    @JsonProperty("ibizsample0002name")
    @JSONField(name = "ibizsample0002name")
    @ApiModelProperty("首页图表数据源名称")
    private String ibizSample0002Name;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [实体]
     */
    public void setDe(String de) {
        this.de = de;
        this.modify("de", de);
    }

    /**
     * 设置 [实体数据量]
     */
    public void setDeNum(Integer deNum) {
        this.deNum = deNum;
        this.modify("denum", deNum);
    }

    /**
     * 设置 [首页图表数据源名称]
     */
    public void setIbizSample0002Name(String ibizSample0002Name) {
        this.ibizSample0002Name = ibizSample0002Name;
        this.modify("ibizsample0002name", ibizSample0002Name);
    }


}
