/**
 * InterFuncKanban 部件模型
 *
 * @export
 * @class InterFuncKanbanModel
 */
export default class InterFuncKanbanModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof InterFuncKanbanKanbanMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'srfmajortext',
				prop: 'ibizbookname',
				dataType: 'TEXT',
			},
			{
				name: 'author',
				prop: 'author',
				dataType: 'TEXT',
			},
			{
				name: 'type',
				prop: 'type',
				dataType: 'TEXT',
			},
			{
				name: 'booknumber',
				prop: 'booknumber',
				dataType: 'INT',
			},
			{
				name: 'press',
				prop: 'press',
				dataType: 'TEXT',
			},
			{
				name: 'srfkey',
				prop: 'ibizbookid',
				dataType: 'GUID',
			},
			{
				name: 'srfmstag',
			},

			{
				name: 'ibizbook',
				prop: 'ibizbookid',
				dataType: 'FONTKEY',
			},

      {
        name: 'n_ibizbookname_like',
        prop: 'n_ibizbookname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_price_gtandeq',
        prop: 'n_price_gtandeq',
        dataType: 'QUERYPARAM'
      },


      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      {
        name:'srfparentdata',
        prop:'srfparentdata'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}