import ViewMessageService from '../view-message-service';
/**
 * 树视图---动态节点（代码表）视图消息服务对象基类
 *
 * @export
 * @class ViewMsg54MessageServiceBase
 */
export default class ViewMsg54MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg54MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg54MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg54MessageServiceBase
     */
    public initBasicParam(){
        this.id = "2dfdde96022e380f9bb5ac9da9183726";
        this.name = "树视图---动态节点（代码表）";
        this.codename = "ViewMsg54";
        this.title = "";
        this.content = "本示例展示树视图动态节点（代码表）节点类型界面呈现。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg54MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}