import { Environment } from '@/environments/environment';
import { UIActionTool, Util } from '@/utils';
import axios from 'axios';
import AppCenterService from "@service/app/app-center-service";
import UIService from '../ui-service';
import { Subject } from 'rxjs';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import IBIZOrderAuthService from '@/authservice/ibizorder/ibizorder-auth-service';
import GridViewLoadUILogic from './grid-view-load-ui-logic';
import OpenYuQueUILogic from './open-yu-que-ui-logic';

/**
 * 订单UI服务对象基类
 * 基于 APP/src/uiservice/%DE_PKGPATH%/%DE_PKGPATH%-ui-service-base.ts.ftl 生成
 * @export
 * @class IBIZOrderUIServiceBase
 */
export default class IBIZOrderUIServiceBase extends UIService {

    /**
     * 是否支持工作流
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public isEnableWorkflow:boolean = false;

    /**
     * 是否支持实体主状态
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public isEnableDEMainState:boolean = true;

    /**
     * 当前UI服务对应的数据服务对象
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public dataService:IBIZOrderService = new IBIZOrderService();

    /**
     * 状态值
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public stateValue: number = 0;

    /**
     * 状态属性
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public stateField: string = "";

    /**
     * 主状态属性集合
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public mainStateFields:Array<any> = ['orderstate'];

    /**
     * 主状态集合Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public allDeMainStateMap:Map<string,string> = new Map();

    /**
     * 主状态操作标识Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public allDeMainStateOPPrivsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  IBIZOrderUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZOrderUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.authService = new IBIZOrderAuthService(opts);
        this.initViewMap();
        this.initDeMainStateMap();
        this.initDeMainStateOPPrivsMap();
    }

    /**
     * 初始化视图Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initViewMap(){
        this.allViewMap.set(':',{viewname:'pickuptreeview',viewType:'DEPICKUPTREEVIEW',srfappde:'ibizorders',component:'ibizorder-pickup-tree-view'});
        this.allViewMap.set(':',{viewname:'f10editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f10-edit-view'});
        this.allViewMap.set(':',{viewname:'usr5editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-usr5-edit-view'});
        this.allViewMap.set(':',{viewname:'seditview2_layout',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-sedit-view2-layout'});
        this.allViewMap.set(':',{viewname:'sgridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sgrid-view'});
        this.allViewMap.set(':',{viewname:'sf2editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sf2-edit-view'});
        this.allViewMap.set(':',{viewname:'f9editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f9-edit-view'});
        this.allViewMap.set(':',{viewname:'selecteditview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-select-edit-view'});
        this.allViewMap.set(':',{viewname:'dataviewexpview',viewType:'DEDATAVIEWEXPVIEW',srfappde:'ibizorders',component:'ibizorder-data-view-exp-view'});
        this.allViewMap.set(':',{viewname:'pluginexgridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-plugin-ex-grid-view'});
        this.allViewMap.set(':',{viewname:'sf15gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf15-grid-view'});
        this.allViewMap.set(':',{viewname:'testcustomlayoutpanelgridexpview',viewType:'DEGRIDEXPVIEW',srfappde:'ibizorders',component:'ibizorder-test-custom-layout-panel-grid-exp-view'});
        this.allViewMap.set(':',{viewname:'listview',viewType:'DELISTVIEW',srfappde:'ibizorders',component:'ibizorder-list-view'});
        this.allViewMap.set(':',{viewname:'dataviewexpview_layout',viewType:'DEDATAVIEWEXPVIEW',srfappde:'ibizorders',component:'ibizorder-data-view-exp-view-layout'});
        this.allViewMap.set(':',{viewname:'wfactionview',viewType:'DEWFACTIONVIEW',srfappde:'ibizorders',component:'ibizorder-wfaction-view'});
        this.allViewMap.set(':',{viewname:'sf4gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf4-grid-view'});
        this.allViewMap.set(':',{viewname:'uiactionplugingridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-uiaction-plugin-grid-view'});
        this.allViewMap.set(':',{viewname:'sgridview2',viewType:'DEGRIDVIEW2',srfappde:'ibizorders',component:'ibizorder-sgrid-view2'});
        this.allViewMap.set(':',{viewname:'sf5gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf5-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-usr2-grid-view'});
        this.allViewMap.set(':',{viewname:'seditview2',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-sedit-view2'});
        this.allViewMap.set(':',{viewname:'seditview4',viewType:'DEEDITVIEW4',srfappde:'ibizorders',component:'ibizorder-sedit-view4'});
        this.allViewMap.set(':',{viewname:'testcltreeexpview',viewType:'DETREEEXPVIEW',srfappde:'ibizorders',component:'ibizorder-test-cltree-exp-view'});
        this.allViewMap.set(':',{viewname:'sf3gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf3-grid-view'});
        this.allViewMap.set('EDITVIEW:MSTAG:30',{viewname:'state30editview2',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-state30-edit-view2'});
        this.allViewMap.set(':',{viewname:'f8editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f8-edit-view'});
        this.allViewMap.set(':',{viewname:'seditview3_layout',viewType:'DEEDITVIEW3',srfappde:'ibizorders',component:'ibizorder-sedit-view3-layout'});
        this.allViewMap.set(':',{viewname:'sf20gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf20-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2chartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-usr2-chart-view'});
        this.allViewMap.set('MDATAVIEW:',{viewname:'gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-grid-view'});
        this.allViewMap.set(':',{viewname:'wfdynaactionview',viewType:'DEWFDYNAACTIONVIEW',srfappde:'ibizorders',component:'ibizorder-wfdyna-action-view'});
        this.allViewMap.set(':',{viewname:'zdytpgridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-zdytpgrid-view'});
        this.allViewMap.set(':',{viewname:'ctrlpluginexgridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-ctrl-plugin-ex-grid-view'});
        this.allViewMap.set(':',{viewname:'wfstartview',viewType:'DEWFSTARTVIEW',srfappde:'ibizorders',component:'ibizorder-wfstart-view'});
        this.allViewMap.set(':',{viewname:'piechartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-pie-chart-view'});
        this.allViewMap.set(':',{viewname:'calendarexpview',viewType:'DECALENDAREXPVIEW',srfappde:'ibizorders',component:'ibizorder-calendar-exp-view'});
        this.allViewMap.set(':',{viewname:'treegridexview_layout',viewType:'DETREEGRIDEXVIEW',srfappde:'ibizorders',component:'ibizorder-tree-grid-ex-view-layout'});
        this.allViewMap.set(':',{viewname:'sf4editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sf4-edit-view'});
        this.allViewMap.set(':',{viewname:'barchartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-bar-chart-view'});
        this.allViewMap.set(':',{viewname:'viewpluginexgridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-view-plugin-ex-grid-view'});
        this.allViewMap.set(':',{viewname:'editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-edit-view'});
        this.allViewMap.set(':',{viewname:'usr3editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-usr3-edit-view'});
        this.allViewMap.set(':',{viewname:'ganttview_layout',viewType:'DEGANTTVIEW',srfappde:'ibizorders',component:'ibizorder-gantt-view-layout'});
        this.allViewMap.set(':',{viewname:'linechartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-line-chart-view'});
        this.allViewMap.set(':',{viewname:'seditview4_layout',viewType:'DEEDITVIEW4',srfappde:'ibizorders',component:'ibizorder-sedit-view4-layout'});
        this.allViewMap.set(':',{viewname:'calendarexpview_layout',viewType:'DECALENDAREXPVIEW',srfappde:'ibizorders',component:'ibizorder-calendar-exp-view-layout'});
        this.allViewMap.set(':',{viewname:'proivateplugingridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-proivate-plugin-grid-view'});
        this.allViewMap.set(':',{viewname:'usr2editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-usr2-edit-view'});
        this.allViewMap.set(':',{viewname:'gridview9',viewType:'DEGRIDVIEW9',srfappde:'ibizorders',component:'ibizorder-grid-view9'});
        this.allViewMap.set(':',{viewname:'sf6gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf6-grid-view'});
        this.allViewMap.set(':',{viewname:'radarchartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-radar-chart-view'});
        this.allViewMap.set(':',{viewname:'listexpview_layout',viewType:'DELISTEXPVIEW',srfappde:'ibizorders',component:'ibizorder-list-exp-view-layout'});
        this.allViewMap.set(':',{viewname:'odsp_wfexpview',viewType:'DEWFEXPVIEW',srfappde:'ibizorders',component:'ibizorder-odsp-wfexp-view'});
        this.allViewMap.set(':',{viewname:'sf7editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sf7-edit-view'});
        this.allViewMap.set(':',{viewname:'s2editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-s2-edit-view'});
        this.allViewMap.set(':',{viewname:'areachartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-area-chart-view'});
        this.allViewMap.set('REDIRECTVIEW:',{viewname:'redirectview',viewType:'DEREDIRECTVIEW',srfappde:'ibizorders',component:'ibizorder-redirect-view'});
        this.allViewMap.set(':',{viewname:'testclchartview',viewType:'DECHARTVIEW',srfappde:'ibizorders',component:'ibizorder-test-clchart-view'});
        this.allViewMap.set(':',{viewname:'f19editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f19-edit-view'});
        this.allViewMap.set(':',{viewname:'f17editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f17-edit-view'});
        this.allViewMap.set(':',{viewname:'seditview3',viewType:'DEEDITVIEW3',srfappde:'ibizorders',component:'ibizorder-sedit-view3'});
        this.allViewMap.set(':',{viewname:'listexpview',viewType:'DELISTEXPVIEW',srfappde:'ibizorders',component:'ibizorder-list-exp-view'});
        this.allViewMap.set(':',{viewname:'ganttview',viewType:'DEGANTTVIEW',srfappde:'ibizorders',component:'ibizorder-gantt-view'});
        this.allViewMap.set(':',{viewname:'pickupgridview',viewType:'DEPICKUPGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-pickup-grid-view'});
        this.allViewMap.set(':',{viewname:'seditview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sedit-view'});
        this.allViewMap.set(':',{viewname:'testcleditview2',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-test-cledit-view2'});
        this.allViewMap.set(':',{viewname:'treegridexview',viewType:'DETREEGRIDEXVIEW',srfappde:'ibizorders',component:'ibizorder-tree-grid-ex-view'});
        this.allViewMap.set('EDITVIEW:MSTAG:10',{viewname:'state10editview2',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-state10-edit-view2'});
        this.allViewMap.set(':',{viewname:'usr4editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-usr4-edit-view'});
        this.allViewMap.set(':',{viewname:'treeexpview',viewType:'DETREEEXPVIEW',srfappde:'ibizorders',component:'ibizorder-tree-exp-view'});
        this.allViewMap.set(':',{viewname:'sf1editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sf1-edit-view'});
        this.allViewMap.set('EDITVIEW:MSTAG:40',{viewname:'state40editview2',viewType:'DEEDITVIEW2',srfappde:'ibizorders',component:'ibizorder-state40-edit-view2'});
        this.allViewMap.set(':',{viewname:'sf1gridview',viewType:'DEGRIDVIEW',srfappde:'ibizorders',component:'ibizorder-sf1-grid-view'});
        this.allViewMap.set(':',{viewname:'treeexpview_layout',viewType:'DETREEEXPVIEW',srfappde:'ibizorders',component:'ibizorder-tree-exp-view-layout'});
        this.allViewMap.set(':',{viewname:'testlogiccustomview',viewType:'DECUSTOMVIEW',srfappde:'ibizorders',component:'ibizorder-test-logic-custom-view'});
        this.allViewMap.set(':',{viewname:'gridexpview',viewType:'DEGRIDEXPVIEW',srfappde:'ibizorders',component:'ibizorder-grid-exp-view'});
        this.allViewMap.set('PICKUPVIEW:',{viewname:'pickupview',viewType:'DEPICKUPVIEW',srfappde:'ibizorders',component:'ibizorder-pickup-view'});
        this.allViewMap.set(':',{viewname:'tabexpview',viewType:'DETABEXPVIEW',srfappde:'ibizorders',component:'ibizorder-tab-exp-view'});
        this.allViewMap.set(':',{viewname:'usr2calendarexpview',viewType:'DECALENDAREXPVIEW',srfappde:'ibizorders',component:'ibizorder-usr2-calendar-exp-view'});
        this.allViewMap.set(':',{viewname:'dashboardview',viewType:'DEPORTALVIEW',srfappde:'ibizorders',component:'ibizorder-dashboard-view'});
        this.allViewMap.set(':',{viewname:'f13editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-f13-edit-view'});
        this.allViewMap.set(':',{viewname:'sf3editview',viewType:'DEEDITVIEW',srfappde:'ibizorders',component:'ibizorder-sf3-edit-view'});
    }

    /**
     * 初始化主状态集合
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initDeMainStateMap(){
        this.allDeMainStateMap.set('10','10');
        this.allDeMainStateMap.set('30','30');
        this.allDeMainStateMap.set('40','40');
    }

    /**
     * 初始化主状态操作标识
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initDeMainStateOPPrivsMap(){
        this.allDeMainStateOPPrivsMap.set('10',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
        this.allDeMainStateOPPrivsMap.set('30',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
        this.allDeMainStateOPPrivsMap.set('40',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
    }

        /**
     * 界面行为插件示例
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_ActionPluginEx(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizorderid']) {
            Object.assign(tempContext, { ibizorder: '%ibizorderid%' });
        } else {
            Object.assign(tempContext, { ibizorder: '%ibizorder%' });
        }
        Object.assign(tempViewParam, { ibizorderid: '%ibizorder%' });
        Object.assign(tempViewParam, { ibizordername: '%ibizordername%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return { ok: true, result: _args };
        }
        const url = `https://www.yuque.com/ibiz/zmg893`;
        return openPopupApp(url);
    }

        /**
     * 单数据主键保存
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_BUIAction1(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizorderid']) {
            Object.assign(tempContext, { ibizorder: '%ibizorderid%' });
        } else {
            Object.assign(tempContext, { ibizorder: '%ibizorder%' });
        }
        Object.assign(tempViewParam, { ibizorderid: '%ibizorder%' });
        Object.assign(tempViewParam, { ibizordername: '%ibizordername%' });
        Object.assign(tempContext, {CONTEXTPARAM1:"%ibizorderid%"});
        Object.assign(tempViewParam, {param2:"%ibizorderid%"});
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        data = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        if (Object.is(actionTarget, "MULTIKEY")) {
            let tempDataArray:Array<any> = [];
            if ((_args.length > 1) && (Object.keys(data).length > 0)) {
                for(let i =0; i < _args.length; i++){
                    let tempObject: any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{ [key]: data[key].split(',')[i] });
                    })
                    tempDataArray.push(tempObject);
                }
            } else {
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        Object.assign(context, tempContext);
        let parentObj: any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data, parentObj);
        }
        Object.assign(context, parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
            context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            if (xData && xData.formValidateStatus instanceof Function) {
                if (!xData.formValidateStatus()) {
                    actionContext.$Notice.error({ title: '错误', desc: actionContext.$t('app.searchform.globalerrortip') as string });
                    return;
                }
            }
            const curService: IBIZOrderService =  new IBIZOrderService();
            let promise: any = curService['Update'](context, data);
            promise.then(async (response: any) => {
                if ((!response || response.status !== 200) && !Array.isArray(response)) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                let { data } = response;
                if (Array.isArray(response) && response.length > 0) {
                    data = [];
                    response.forEach((item: any) => {
                        data.push(item.data);
                    })
                }
                actionContext.$Notice.success({ title: '成功', desc: '后台界面行为（保存）执行成功' });
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

        /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_Delete(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizorderid']) {
            Object.assign(tempContext, { ibizorder: '%ibizorderid%' });
        } else {
            Object.assign(tempContext, { ibizorder: '%ibizorder%' });
        }
        Object.assign(tempViewParam, { ibizorderid: '%ibizorder%' });
        Object.assign(tempViewParam, { ibizordername: '%ibizordername%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        data = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        if (Object.is(actionTarget, "MULTIKEY")) {
            let tempDataArray:Array<any> = [];
            if ((_args.length > 1) && (Object.keys(data).length > 0)) {
                for(let i =0; i < _args.length; i++){
                    let tempObject: any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{ [key]: data[key].split(',')[i] });
                    })
                    tempDataArray.push(tempObject);
                }
            } else {
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        Object.assign(context, tempContext);
        let parentObj: any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data, parentObj);
        }
        Object.assign(context, parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
            context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            if (xData && xData.formValidateStatus instanceof Function) {
                if (!xData.formValidateStatus()) {
                    actionContext.$Notice.error({ title: '错误', desc: actionContext.$t('app.searchform.globalerrortip') as string });
                    return;
                }
            }
            const curService: IBIZOrderService =  new IBIZOrderService();
            let promise: any = curService['Remove'](context, data);
            promise.then(async (response: any) => {
                if ((!response || response.status !== 200) && !Array.isArray(response)) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                let { data } = response;
                if (Array.isArray(response) && response.length > 0) {
                    data = [];
                    response.forEach((item: any) => {
                        data.push(item.data);
                    })
                }
                actionContext.$Notice.success({ title: '成功', desc: '成功删除数据！' });
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                if (xData && xData.getControlType instanceof Function && xData.getControlType() == 'FORM') {
                    AppCenterService.notifyMessage({ name: "IBIZOrder", action: 'appRefresh', data: args });
                }
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

        /**
     * 前台界面行为（编辑）
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_FUIAction1(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        Object.assign(tempContext, {IBIZORDERID:"15c8e85a50dae2893c26945df5b58e4e",CONTEXTPARAM1:"%ibizorderid%",IBIZORDER:"15c8e85a50dae2893c26945df5b58e4e"});
        Object.assign(tempViewParam, {param2:"%ibizorderid%"});
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizorders', parameterName: 'ibizorder' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            //  后续界面行为
            return { ok: true, result: args };
        }
        return openIndexViewTab(data);
    }

        /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_ZDYUpdate(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        if (_args && args[0] && args[0]['ibizorderid']) {
            Object.assign(tempContext, { ibizorder: '%ibizorderid%' });
        } else {
            Object.assign(tempContext, { ibizorder: '%ibizorder%' });
        }
        Object.assign(tempViewParam, { ibizorderid: '%ibizorder%' });
        Object.assign(tempViewParam, { ibizordername: '%ibizordername%' });
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        data = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        if (Object.is(actionTarget, "MULTIKEY")) {
            let tempDataArray:Array<any> = [];
            if ((_args.length > 1) && (Object.keys(data).length > 0)) {
                for(let i =0; i < _args.length; i++){
                    let tempObject: any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{ [key]: data[key].split(',')[i] });
                    })
                    tempDataArray.push(tempObject);
                }
            } else {
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        Object.assign(context, tempContext);
        let parentObj: any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data, parentObj);
        }
        Object.assign(context, parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
            context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            if (xData && xData.formValidateStatus instanceof Function) {
                if (!xData.formValidateStatus()) {
                    actionContext.$Notice.error({ title: '错误', desc: actionContext.$t('app.searchform.globalerrortip') as string });
                    return;
                }
            }
            const curService: IBIZOrderService =  new IBIZOrderService();
            let promise: any = curService['Remove'](context, data);
            promise.then(async (response: any) => {
                if ((!response || response.status !== 200) && !Array.isArray(response)) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                let { data } = response;
                if (Array.isArray(response) && response.length > 0) {
                    data = [];
                    response.forEach((item: any) => {
                        data.push(item.data);
                    })
                }
                actionContext.$Notice.success({ title: '成功', desc: '删除成功！' });
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

        /**
     * 多项数据主键保存
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_mulUpdate(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'MULTIKEY';
        if (_args && args[0] && args[0]['ibizorderid']) {
            Object.assign(tempContext, { ibizorder: '%ibizorderid%' });
        } else {
            Object.assign(tempContext, { ibizorder: '%ibizorder%' });
        }
        Object.assign(tempViewParam, { ibizorderid: '%ibizorder%' });
        Object.assign(tempViewParam, { ibizordername: '%ibizordername%' });
        Object.assign(tempViewParam, {ordertype:"%ordertype%",orderstate:"%orderstate%"});
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        data = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        if (Object.is(actionTarget, "MULTIKEY")) {
            let tempDataArray:Array<any> = [];
            if ((_args.length > 1) && (Object.keys(data).length > 0)) {
                for(let i =0; i < _args.length; i++){
                    let tempObject: any = {};
                    Object.keys(data).forEach((key:string) =>{
                        Object.assign(tempObject,{ [key]: data[key].split(',')[i] });
                    })
                    tempDataArray.push(tempObject);
                }
            } else {
                tempDataArray.push(data);
            }
            data = tempDataArray;
        }
        Object.assign(context, tempContext);
        let parentObj: any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        if(!Object.is(actionTarget,"MULTIKEY")){
            Object.assign(data, parentObj);
        }
        Object.assign(context, parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
            context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            if (xData && xData.formValidateStatus instanceof Function) {
                if (!xData.formValidateStatus()) {
                    actionContext.$Notice.error({ title: '错误', desc: actionContext.$t('app.searchform.globalerrortip') as string });
                    return;
                }
            }
            const curService: IBIZOrderService =  new IBIZOrderService();
            const promiseArray: any[] = [];
            if (data && data.length > 0) {
                const srfkeys = context['ibizorder'] ? context['ibizorder'].split(',') : [];
                data.forEach((ele: any, index: number) => {
                    const tempContext = Util.deepCopy(context);
                    Object.assign(tempContext, { ibizorder: srfkeys[index] });
                    promiseArray.push(curService['MulUpdate'](tempContext, ele));
                })
            }
            let promise: any = Promise.all(promiseArray);
            promise.then(async (response: any) => {
                if ((!response || response.status !== 200) && !Array.isArray(response)) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                let { data } = response;
                if (Array.isArray(response) && response.length > 0) {
                    data = [];
                    response.forEach((item: any) => {
                        data.push(item.data);
                    })
                }
                actionContext.$Notice.success({ title: '成功', desc: '批量修改成功' });
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

        /**
     * 打开文档
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_open_document(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        let data: any = {};
        let tempData: any = {};
        let tempContext: any = {};
        let tempViewParam: any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        tempContext = UIActionTool.handleContextParam(actionTarget, _args, context, params, tempContext);
        tempViewParam = UIActionTool.handleActionParam(actionTarget, _args, context, params, tempViewParam);
        Object.assign(context, tempContext);
        Object.assign(params, data);
        let parentObj:any = {
            srfparentdename: srfParentDeName ? srfParentDeName : null,
            srfparentkey: srfParentDeName ? context[srfParentDeName.toLowerCase()] : null
        };
        Object.assign(context, parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return { ok: true, result: _args };
        }
        const url = `https://www.yuque.com/ibiz/wuf19n/cwqg10`;
        return openPopupApp(url);
    }

        /**
     * 界面逻辑
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_panel_A424afda77415fcfb6f_button_calluilogic16_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('OpenYuQue', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }

        /**
     * 语雀文档
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     * @memberof IBIZOrderUIService
     */
    public async IBIZOrder_panel_Usr1102678360_open_yuque_click(args: any[], context:any = {}, params: any={}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?:string) {
        const _context: any = Object.assign(context, actionContext.context);
        const _params: any = Object.assign(params, actionContext.viewparams);
        return this.executeUILogic('OpenYuQue', args, _context, _params, $event, xData, actionContext, srfParentDeName);
    }


    /**
     * 获取指定数据的重定向页面
     * 
     * @param srfkey 数据主键
     * @param isEnableWorkflow  重定向视图是否需要处理流程中的数据
     * @param args  {context,viewParams} 用于计算流程   
     * @memberof  IBIZOrderUIServiceBase
     */
    public async getRDAppView(srfkey:string,isEnableWorkflow:boolean,args?:any){
        this.isEnableWorkflow = isEnableWorkflow;
        // 进行数据查询
        let result:any = await this.dataService.Get({ibizorder:srfkey});
        const curData:any = result.data;
        //判断当前数据模式,默认为true，todo
        const iRealDEModel:boolean = true;
        let bDataInWF:boolean = false;
		let bWFMode:any = false;
		if (this.isEnableWorkflow) {
            return this.getWFView();
        } else {
            if ((args && args.viewParam && args.viewParam.srfwf && this.InWorkflowArray.indexOf(args.viewParam.srfwf) !== -1)) {
                return this.getWFView();
            }
        }
        let strPDTViewParam:string = await this.getDESDDEViewPDTParam(curData, bDataInWF, bWFMode);
        return this.allViewMap.get(strPDTViewParam);
    }

    /**
	 * 获取实际的数据类型
     * 
     * @memberof  IBIZOrderUIServiceBase
	 */
	public getRealDEType(entity:any){

    }

    /**
     * 获取实体单数据实体视图预定义参数
     * 
     * @param curData 当前数据
     * @param bDataInWF 是否有数据在工作流中
     * @param bWFMode   是否工作流模式
     * @memberof  IBIZOrderUIServiceBase
     */
    public async getDESDDEViewPDTParam(curData:any, bDataInWF:boolean, bWFMode:boolean){
        let strPDTParam:string = '';
		if (bDataInWF) {
			// 判断数据是否在流程中
        }
        //多表单，todo
        const multiFormDEField:string|null =null;

        if (multiFormDEField) {
			const objFormValue:string = curData[multiFormDEField];
			if(!Environment.isAppMode){
				return 'MOBEDITVIEW:'+objFormValue;
			}
			return 'EDITVIEW:'+objFormValue;
        }
		if(!Environment.isAppMode){
            if(this.getDEMainStateTag(curData)){
                return `MOBEDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
            }
			return 'MOBEDITVIEW:';
        }
        if(this.getDEMainStateTag(curData)){
            return `EDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
        }
		return 'EDITVIEW:';
    }

    /**
     * 获取数据对象的主状态标识
     * 
     * @param curData 当前数据
     * @memberof  IBIZOrderUIServiceBase
     */  
    public getDEMainStateTag(curData:any){
        if(this.mainStateFields.length === 0) return null;

        this.mainStateFields.forEach((singleMainField:any) =>{
            if(!(singleMainField in curData)){
                console.warn(`当前数据对象不包含属性「${singleMainField}」，根据「${singleMainField}」属性进行的主状态计算默认为空值`);
            }
        })
        for (let i = 0; i <= 1; i++) {
            let strTag:string = (curData[this.mainStateFields[0]] != null && curData[this.mainStateFields[0]] !== "")?(i == 0) ? `${curData[this.mainStateFields[0]]}` : "":"";
            if (this.mainStateFields.length >= 2) {
                for (let j = 0; j <= 1; j++) {
                    let strTag2:string = (curData[this.mainStateFields[1]] != null && curData[this.mainStateFields[1]] !== "")?`${strTag}__${(j == 0) ? `${curData[this.mainStateFields[1]]}` : ""}`:strTag;
                    if (this.mainStateFields.length >= 3) {
                        for (let k = 0; k <= 1; k++) {
                            let strTag3:string = (curData[this.mainStateFields[2]] != null && curData[this.mainStateFields[2]] !== "")?`${strTag2}__${(k == 0) ? `${curData[this.mainStateFields[2]]}` : ""}`:strTag2;
                            // 判断是否存在
                            return this.allDeMainStateMap.get(strTag3);
                        }
                    }else{
                        return this.allDeMainStateMap.get(strTag2);
                    }
                }
            }else{
                return this.allDeMainStateMap.get(strTag);
            }
        }
        return null;
    }

    /**
     * 获取数据对象当前操作标识
     * 
     * @param data 当前数据
     * @memberof  IBIZOrderUIServiceBase
     */  
    public getDEMainStateOPPrivs(data:any){
        if(this.getDEMainStateTag(data)){
            return this.allDeMainStateOPPrivsMap.get((this.getDEMainStateTag(data) as string));
        }else{
            return null;
        }
    }

    /**
     * 获取数据对象所有的操作标识
     * 
     * @param data 当前数据
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public getAllOPPrivs(data:any){
       return this.authService.getOPPrivs(this.getDEMainStateOPPrivs(data));
    }

    /**
     * 执行界面逻辑
     *
     * @param {string} name
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof UIService
     */
    public async executeUILogic(name: string, args: any[], context?: any, params?: any, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string | undefined): Promise<any> {
        //  转化参数
        let data: any = null;
        if (args && Array.isArray(args) && args.length > 0) {
            data = args[0];
        } else {
            data = (Object.keys(args).length > 0) ? args : {};
        }
        if (name === 'GridViewLoad') {
            return await GridViewLoadUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
        if (name === 'OpenYuQue') {
            return await OpenYuQueUILogic.getInstance().execute(data, context, params, $event, xData, actionContext, srfParentDeName);
        }
    } 

}