import AuthService from '../auth-service';

/**
 * 示例实体01权限服务对象基类
 * 基于 APP/src/authservice/%DE_PKGPATH%/%DE_PKGPATH%-auth-service-base.ts.ftl 生成
 * @export
 * @class IBIZSample0001AuthServiceBase
 * @extends {AuthService}
 */
export default class IBIZSample0001AuthServiceBase extends AuthService {

    /**
     * Creates an instance of  IBIZSample0001AuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZSample0001AuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof IBIZSample0001AuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = this.getSysOPPrivs();
        let copyDefaultOPPrivs:any = JSON.parse(JSON.stringify(curDefaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        // 统一资源优先
        Object.keys(curDefaultOPPrivs).forEach((name:string) => {
            if(this.sysOPPrivsMap.get(name) && copyDefaultOPPrivs[name] === 0){
                curDefaultOPPrivs[name] = copyDefaultOPPrivs[name];
            }
        });
        return curDefaultOPPrivs;
    }

}