package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZVIEWMESS;
import cn.ibizlab.core.sample.service.IIBIZVIEWMESSService;
import cn.ibizlab.core.sample.filter.IBIZVIEWMESSSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"视图数据信息实体" })
@RestController("DemoAPI-ibizviewmess")
@RequestMapping("")
public class IBIZVIEWMESSResource {

    @Autowired
    public IIBIZVIEWMESSService ibizviewmessService;

    @Autowired
    @Lazy
    public IBIZVIEWMESSMapping ibizviewmessMapping;

    @PreAuthorize("hasPermission(this.ibizviewmessMapping.toDomain(#ibizviewmessdto),'DemoSys-IBIZVIEWMESS-Create')")
    @ApiOperation(value = "新建视图数据信息实体", tags = {"视图数据信息实体" },  notes = "新建视图数据信息实体")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizviewmesses")
    public ResponseEntity<IBIZVIEWMESSDTO> create(@Validated @RequestBody IBIZVIEWMESSDTO ibizviewmessdto) {
        IBIZVIEWMESS domain = ibizviewmessMapping.toDomain(ibizviewmessdto);
		ibizviewmessService.create(domain);
        IBIZVIEWMESSDTO dto = ibizviewmessMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizviewmessMapping.toDomain(#ibizviewmessdtos),'DemoSys-IBIZVIEWMESS-Create')")
    @ApiOperation(value = "批量新建视图数据信息实体", tags = {"视图数据信息实体" },  notes = "批量新建视图数据信息实体")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizviewmesses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZVIEWMESSDTO> ibizviewmessdtos) {
        ibizviewmessService.createBatch(ibizviewmessMapping.toDomain(ibizviewmessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizviewmess" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizviewmessService.get(#ibizviewmess_id),'DemoSys-IBIZVIEWMESS-Update')")
    @ApiOperation(value = "更新视图数据信息实体", tags = {"视图数据信息实体" },  notes = "更新视图数据信息实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizviewmesses/{ibizviewmess_id}")
    public ResponseEntity<IBIZVIEWMESSDTO> update(@PathVariable("ibizviewmess_id") String ibizviewmess_id, @RequestBody IBIZVIEWMESSDTO ibizviewmessdto) {
		IBIZVIEWMESS domain  = ibizviewmessMapping.toDomain(ibizviewmessdto);
        domain .setIbizviewmessid(ibizviewmess_id);
		ibizviewmessService.update(domain );
		IBIZVIEWMESSDTO dto = ibizviewmessMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizviewmessService.getIbizviewmessByEntities(this.ibizviewmessMapping.toDomain(#ibizviewmessdtos)),'DemoSys-IBIZVIEWMESS-Update')")
    @ApiOperation(value = "批量更新视图数据信息实体", tags = {"视图数据信息实体" },  notes = "批量更新视图数据信息实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizviewmesses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZVIEWMESSDTO> ibizviewmessdtos) {
        ibizviewmessService.updateBatch(ibizviewmessMapping.toDomain(ibizviewmessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizviewmessService.get(#ibizviewmess_id),'DemoSys-IBIZVIEWMESS-Remove')")
    @ApiOperation(value = "删除视图数据信息实体", tags = {"视图数据信息实体" },  notes = "删除视图数据信息实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizviewmesses/{ibizviewmess_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizviewmess_id") String ibizviewmess_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizviewmessService.remove(ibizviewmess_id));
    }

    @PreAuthorize("hasPermission(this.ibizviewmessService.getIbizviewmessByIds(#ids),'DemoSys-IBIZVIEWMESS-Remove')")
    @ApiOperation(value = "批量删除视图数据信息实体", tags = {"视图数据信息实体" },  notes = "批量删除视图数据信息实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizviewmesses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizviewmessService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizviewmessMapping.toDomain(returnObject.body),'DemoSys-IBIZVIEWMESS-Get')")
    @ApiOperation(value = "获取视图数据信息实体", tags = {"视图数据信息实体" },  notes = "获取视图数据信息实体")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizviewmesses/{ibizviewmess_id}")
    public ResponseEntity<IBIZVIEWMESSDTO> get(@PathVariable("ibizviewmess_id") String ibizviewmess_id) {
        IBIZVIEWMESS domain = ibizviewmessService.get(ibizviewmess_id);
        IBIZVIEWMESSDTO dto = ibizviewmessMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取视图数据信息实体草稿", tags = {"视图数据信息实体" },  notes = "获取视图数据信息实体草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizviewmesses/getdraft")
    public ResponseEntity<IBIZVIEWMESSDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizviewmessMapping.toDto(ibizviewmessService.getDraft(new IBIZVIEWMESS())));
    }

    @ApiOperation(value = "检查视图数据信息实体", tags = {"视图数据信息实体" },  notes = "检查视图数据信息实体")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizviewmesses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZVIEWMESSDTO ibizviewmessdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizviewmessService.checkKey(ibizviewmessMapping.toDomain(ibizviewmessdto)));
    }

    @PreAuthorize("hasPermission(this.ibizviewmessMapping.toDomain(#ibizviewmessdto),'DemoSys-IBIZVIEWMESS-Save')")
    @ApiOperation(value = "保存视图数据信息实体", tags = {"视图数据信息实体" },  notes = "保存视图数据信息实体")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizviewmesses/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZVIEWMESSDTO ibizviewmessdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizviewmessService.save(ibizviewmessMapping.toDomain(ibizviewmessdto)));
    }

    @PreAuthorize("hasPermission(this.ibizviewmessMapping.toDomain(#ibizviewmessdtos),'DemoSys-IBIZVIEWMESS-Save')")
    @ApiOperation(value = "批量保存视图数据信息实体", tags = {"视图数据信息实体" },  notes = "批量保存视图数据信息实体")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizviewmesses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZVIEWMESSDTO> ibizviewmessdtos) {
        ibizviewmessService.saveBatch(ibizviewmessMapping.toDomain(ibizviewmessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZVIEWMESS-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZVIEWMESS-Get')")
	@ApiOperation(value = "获取数据集", tags = {"视图数据信息实体" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizviewmesses/fetchdefault")
	public ResponseEntity<List<IBIZVIEWMESSDTO>> fetchDefault(IBIZVIEWMESSSearchContext context) {
        Page<IBIZVIEWMESS> domains = ibizviewmessService.searchDefault(context) ;
        List<IBIZVIEWMESSDTO> list = ibizviewmessMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZVIEWMESS-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZVIEWMESS-Get')")
	@ApiOperation(value = "查询数据集", tags = {"视图数据信息实体" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizviewmesses/searchdefault")
	public ResponseEntity<Page<IBIZVIEWMESSDTO>> searchDefault(@RequestBody IBIZVIEWMESSSearchContext context) {
        Page<IBIZVIEWMESS> domains = ibizviewmessService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizviewmessMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

